/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.Preconditions;

public class JobEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobVertex target;
    private final DistributionPattern distributionPattern;
    private SubtaskStateMapper downstreamSubtaskStateMapper = SubtaskStateMapper.ROUND_ROBIN;
    private SubtaskStateMapper upstreamSubtaskStateMapper = SubtaskStateMapper.ROUND_ROBIN;
    private final IntermediateDataSet source;
    private String shipStrategyName;
    private final boolean isBroadcast;
    private final boolean isForward;
    private String preProcessingOperationName;
    private String operatorLevelCachingDescription;
    private final int typeNumber;
    private final boolean interInputsKeysCorrelated;
    private final boolean intraInputKeyCorrelated;

    public JobEdge(IntermediateDataSet source, JobVertex target, DistributionPattern distributionPattern, boolean isBroadcast, boolean isForward, int typeNumber, boolean interInputsKeysCorrelated, boolean intraInputKeyCorrelated) {
        if (source == null || target == null || distributionPattern == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.distributionPattern = distributionPattern;
        this.source = source;
        this.isBroadcast = isBroadcast;
        this.isForward = isForward;
        this.typeNumber = typeNumber;
        this.interInputsKeysCorrelated = interInputsKeysCorrelated;
        this.intraInputKeyCorrelated = intraInputKeyCorrelated;
    }

    public IntermediateDataSet getSource() {
        return this.source;
    }

    public JobVertex getTarget() {
        return this.target;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public IntermediateDataSetID getSourceId() {
        return this.source.getId();
    }

    public String getShipStrategyName() {
        return this.shipStrategyName;
    }

    public void setShipStrategyName(String shipStrategyName) {
        this.shipStrategyName = shipStrategyName;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return this.downstreamSubtaskStateMapper;
    }

    public void setDownstreamSubtaskStateMapper(SubtaskStateMapper downstreamSubtaskStateMapper) {
        this.downstreamSubtaskStateMapper = (SubtaskStateMapper)((Object)Preconditions.checkNotNull((Object)((Object)downstreamSubtaskStateMapper)));
    }

    public SubtaskStateMapper getUpstreamSubtaskStateMapper() {
        return this.upstreamSubtaskStateMapper;
    }

    public void setUpstreamSubtaskStateMapper(SubtaskStateMapper upstreamSubtaskStateMapper) {
        this.upstreamSubtaskStateMapper = (SubtaskStateMapper)((Object)Preconditions.checkNotNull((Object)((Object)upstreamSubtaskStateMapper)));
    }

    public String getPreProcessingOperationName() {
        return this.preProcessingOperationName;
    }

    public void setPreProcessingOperationName(String preProcessingOperationName) {
        this.preProcessingOperationName = preProcessingOperationName;
    }

    public String getOperatorLevelCachingDescription() {
        return this.operatorLevelCachingDescription;
    }

    public void setOperatorLevelCachingDescription(String operatorLevelCachingDescription) {
        this.operatorLevelCachingDescription = operatorLevelCachingDescription;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public boolean areInterInputsKeysCorrelated() {
        return this.interInputsKeysCorrelated;
    }

    public boolean isIntraInputKeyCorrelated() {
        return this.intraInputKeyCorrelated;
    }

    public String toString() {
        return String.format("%s --> %s [%s]", this.source.getId(), this.target, this.distributionPattern.name());
    }
}

