/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.FileExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.shaded.guava33.com.google.common.base.Ticker;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public abstract class SessionClusterEntrypoint
extends ClusterEntrypoint {
    public SessionClusterEntrypoint(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) throws IOException {
        JobManagerOptions.JobStoreType jobStoreType = (JobManagerOptions.JobStoreType)configuration.get(JobManagerOptions.JOB_STORE_TYPE);
        Duration expirationTime = Duration.ofSeconds((Long)configuration.get(JobManagerOptions.JOB_STORE_EXPIRATION_TIME));
        int maximumCapacity = (Integer)configuration.get(JobManagerOptions.JOB_STORE_MAX_CAPACITY);
        switch (jobStoreType) {
            case File: {
                File tmpDir = new File(ConfigurationUtils.parseTempDirectories((Configuration)configuration)[0]);
                long maximumCacheSizeBytes = (Long)configuration.get(JobManagerOptions.JOB_STORE_CACHE_SIZE);
                return new FileExecutionGraphInfoStore(tmpDir, expirationTime, maximumCapacity, maximumCacheSizeBytes, scheduledExecutor, Ticker.systemTicker());
            }
            case Memory: {
                return new MemoryExecutionGraphInfoStore(expirationTime, maximumCapacity, scheduledExecutor, Ticker.systemTicker());
            }
        }
        throw new IllegalArgumentException("Unsupported job store type " + jobStoreType);
    }
}

