/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.InitializationStatus;

class JobInitializationMetrics {
    public static final long UNSET = -1L;
    private final long checkpointId;
    private final long stateSize;
    private final InitializationStatus status;
    private final long initializationStartTs;
    private final long initializationEndTs;
    private final Map<String, SumMaxDuration> durationMetrics;

    public JobInitializationMetrics(long checkpointId, long stateSize, InitializationStatus status, long initializationStartTs, long initializationEndTs, Map<String, SumMaxDuration> durationMetrics) {
        this.checkpointId = checkpointId;
        this.stateSize = stateSize;
        this.status = status;
        this.initializationStartTs = initializationStartTs;
        this.initializationEndTs = initializationEndTs;
        this.durationMetrics = durationMetrics;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public InitializationStatus getStatus() {
        return this.status;
    }

    public long getStartTs() {
        return this.initializationStartTs;
    }

    public long getEndTs() {
        return this.initializationEndTs;
    }

    public Map<String, SumMaxDuration> getDurationMetrics() {
        return this.durationMetrics;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{checkpointId=" + this.checkpointId + ", stateSize=" + this.stateSize + ", status=" + this.status + ", initializationStartTs=" + this.initializationStartTs + ", " + this.durationMetrics + "}";
    }

    static class SumMaxDuration {
        private final String name;
        private long sumDuration = 0L;
        private long maxDuration = 0L;

        SumMaxDuration(String name) {
            this.name = name;
        }

        SumMaxDuration addDuration(long duration) {
            if (duration == -1L) {
                return this;
            }
            this.sumDuration += duration;
            this.maxDuration = Math.max(this.maxDuration, duration);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public long getSum() {
            return this.sumDuration;
        }

        public long getMax() {
            return this.maxDuration;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.sumDuration, this.maxDuration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SumMaxDuration that = (SumMaxDuration)o;
            return this.name == that.name && this.sumDuration == that.sumDuration && this.maxDuration == that.maxDuration;
        }

        public String toString() {
            return String.format("%s(max=%d, sum=%d)", this.name, this.maxDuration, this.sumDuration);
        }
    }
}

