/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupImpl;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobVertex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "(unnamed vertex)";
    public static final int MAX_PARALLELISM_DEFAULT = -1;
    private final JobVertexID id;
    private final List<OperatorIDPair> operatorIDs;
    private final Map<IntermediateDataSetID, IntermediateDataSet> results = new LinkedHashMap<IntermediateDataSetID, IntermediateDataSet>();
    private final List<JobEdge> inputs = new ArrayList<JobEdge>();
    private final List<SerializedValue<OperatorCoordinator.Provider>> operatorCoordinators = new ArrayList<SerializedValue<OperatorCoordinator.Provider>>();
    private int parallelism = -1;
    private int maxParallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private Configuration configuration;
    private String invokableClassName;
    private boolean isStoppable = false;
    private InputSplitSource<?> inputSplitSource;
    private String name;
    @Nullable
    private SlotSharingGroup slotSharingGroup;
    @Nullable
    private CoLocationGroupImpl coLocationGroup;
    private String operatorName;
    private String operatorDescription;
    private String operatorPrettyName;
    private String resultOptimizerProperties;
    private final List<IntermediateDataSetID> intermediateDataSetIdsToConsume = new ArrayList<IntermediateDataSetID>();
    private boolean supportsConcurrentExecutionAttempts = true;
    private boolean anyOutputBlocking = false;
    private boolean parallelismConfigured = false;
    private boolean dynamicParallelism = false;

    public JobVertex(String name) {
        this(name, null);
    }

    public JobVertex(String name, JobVertexID id) {
        this.name = name == null ? DEFAULT_NAME : name;
        this.id = id == null ? new JobVertexID() : id;
        OperatorIDPair operatorIDPair = OperatorIDPair.generatedIDOnly(OperatorID.fromJobVertexID(this.id));
        this.operatorIDs = Collections.singletonList(operatorIDPair);
    }

    public JobVertex(String name, JobVertexID primaryId, List<OperatorIDPair> operatorIDPairs) {
        this.name = name == null ? DEFAULT_NAME : name;
        this.id = primaryId == null ? new JobVertexID() : primaryId;
        this.operatorIDs = Collections.unmodifiableList(operatorIDPairs);
    }

    public JobVertexID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? DEFAULT_NAME : name;
    }

    public int getNumberOfProducedIntermediateDataSets() {
        return this.results.size();
    }

    public int getNumberOfInputs() {
        return this.inputs.size();
    }

    public List<OperatorIDPair> getOperatorIDs() {
        return this.operatorIDs;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    public void setInvokableClass(Class<? extends TaskInvokable> invokable) {
        Preconditions.checkNotNull(invokable);
        this.invokableClassName = invokable.getName();
    }

    public void setParallelismConfigured(boolean parallelismConfigured) {
        this.parallelismConfigured = parallelismConfigured;
    }

    public boolean isParallelismConfigured() {
        return this.parallelismConfigured;
    }

    public void setDynamicParallelism(int parallelism) {
        this.setParallelism(parallelism);
        this.dynamicParallelism = true;
    }

    public boolean isDynamicParallelism() {
        return this.parallelism == -1 || this.dynamicParallelism;
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public Class<? extends TaskInvokable> getInvokableClass(ClassLoader cl) {
        if (cl == null) {
            throw new NullPointerException("The classloader must not be null.");
        }
        if (this.invokableClassName == null) {
            return null;
        }
        try {
            return Class.forName(this.invokableClassName, true, cl).asSubclass(TaskInvokable.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The user-code class could not be resolved.", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The user-code class is no subclass of " + TaskInvokable.class.getName(), e);
        }
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 1 && parallelism != -1) {
            throw new IllegalArgumentException("The parallelism must be at least one, or -1 (unset).");
        }
        this.parallelism = parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.minResources = (ResourceSpec)Preconditions.checkNotNull((Object)minResources);
        this.preferredResources = (ResourceSpec)Preconditions.checkNotNull((Object)preferredResources);
    }

    public InputSplitSource<?> getInputSplitSource() {
        return this.inputSplitSource;
    }

    public void setInputSplitSource(InputSplitSource<?> inputSplitSource) {
        this.inputSplitSource = inputSplitSource;
    }

    public List<IntermediateDataSet> getProducedDataSets() {
        return new ArrayList<IntermediateDataSet>(this.results.values());
    }

    public List<JobEdge> getInputs() {
        return this.inputs;
    }

    public List<SerializedValue<OperatorCoordinator.Provider>> getOperatorCoordinators() {
        return Collections.unmodifiableList(this.operatorCoordinators);
    }

    public void addOperatorCoordinator(SerializedValue<OperatorCoordinator.Provider> serializedCoordinatorProvider) {
        this.operatorCoordinators.add(serializedCoordinatorProvider);
    }

    public void setSlotSharingGroup(SlotSharingGroup grp) {
        Preconditions.checkNotNull((Object)grp);
        if (this.slotSharingGroup != null) {
            this.slotSharingGroup.removeVertexFromGroup(this.getID());
        }
        grp.addVertexToGroup(this.getID());
        this.slotSharingGroup = grp;
    }

    public SlotSharingGroup getSlotSharingGroup() {
        if (this.slotSharingGroup == null) {
            this.setSlotSharingGroup(new SlotSharingGroup());
        }
        return this.slotSharingGroup;
    }

    public void setStrictlyCoLocatedWith(JobVertex strictlyCoLocatedWith) {
        if (this.slotSharingGroup == null || this.slotSharingGroup != strictlyCoLocatedWith.slotSharingGroup) {
            throw new IllegalArgumentException("Strict co-location requires that both vertices are in the same slot sharing group.");
        }
        CoLocationGroupImpl thisGroup = this.coLocationGroup;
        CoLocationGroupImpl otherGroup = strictlyCoLocatedWith.coLocationGroup;
        if (otherGroup == null) {
            if (thisGroup == null) {
                CoLocationGroupImpl group;
                this.coLocationGroup = group = new CoLocationGroupImpl(this, strictlyCoLocatedWith);
                strictlyCoLocatedWith.coLocationGroup = group;
            } else {
                thisGroup.addVertex(strictlyCoLocatedWith);
                strictlyCoLocatedWith.coLocationGroup = thisGroup;
            }
        } else if (thisGroup == null) {
            otherGroup.addVertex(this);
            this.coLocationGroup = otherGroup;
        } else {
            thisGroup.mergeInto(otherGroup);
        }
    }

    @Nullable
    public CoLocationGroup getCoLocationGroup() {
        return this.coLocationGroup;
    }

    public void updateCoLocationGroup(CoLocationGroupImpl group) {
        this.coLocationGroup = group;
    }

    public IntermediateDataSet getOrCreateResultDataSet(IntermediateDataSetID id, ResultPartitionType partitionType) {
        this.anyOutputBlocking |= partitionType.isBlockingOrBlockingPersistentResultPartition();
        return this.results.computeIfAbsent(id, key -> new IntermediateDataSet(id, partitionType, this));
    }

    public JobEdge connectNewDataSetAsInput(JobVertex input, DistributionPattern distPattern, ResultPartitionType partitionType) {
        return this.connectNewDataSetAsInput(input, distPattern, partitionType, false);
    }

    public JobEdge connectNewDataSetAsInput(JobVertex input, DistributionPattern distPattern, ResultPartitionType partitionType, boolean isBroadcast) {
        return this.connectNewDataSetAsInput(input, distPattern, partitionType, new IntermediateDataSetID(), isBroadcast);
    }

    public JobEdge connectNewDataSetAsInput(JobVertex input, DistributionPattern distPattern, ResultPartitionType partitionType, IntermediateDataSetID intermediateDataSetId, boolean isBroadcast) {
        IntermediateDataSet dataSet = input.getOrCreateResultDataSet(intermediateDataSetId, partitionType);
        JobEdge edge = new JobEdge(dataSet, this, distPattern, isBroadcast);
        this.inputs.add(edge);
        dataSet.addConsumer(edge);
        return edge;
    }

    public boolean isInputVertex() {
        return this.inputs.isEmpty();
    }

    public boolean isStoppable() {
        return this.isStoppable;
    }

    public boolean isOutputVertex() {
        return this.results.isEmpty();
    }

    public boolean hasNoConnectedInputs() {
        return this.inputs.isEmpty();
    }

    public void setSupportsConcurrentExecutionAttempts(boolean supportsConcurrentExecutionAttempts) {
        this.supportsConcurrentExecutionAttempts = supportsConcurrentExecutionAttempts;
    }

    public boolean isSupportsConcurrentExecutionAttempts() {
        return this.supportsConcurrentExecutionAttempts;
    }

    public boolean isAnyOutputBlocking() {
        return this.anyOutputBlocking;
    }

    public void initializeOnMaster(InitializeOnMasterContext context) throws Exception {
    }

    public void finalizeOnMaster(FinalizeOnMasterContext context) throws Exception {
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorDescription() {
        return this.operatorDescription;
    }

    public void setOperatorDescription(String operatorDescription) {
        this.operatorDescription = operatorDescription;
    }

    public void setOperatorPrettyName(String operatorPrettyName) {
        this.operatorPrettyName = operatorPrettyName;
    }

    public String getOperatorPrettyName() {
        return this.operatorPrettyName;
    }

    public String getResultOptimizerProperties() {
        return this.resultOptimizerProperties;
    }

    public void setResultOptimizerProperties(String resultOptimizerProperties) {
        this.resultOptimizerProperties = resultOptimizerProperties;
    }

    public void addIntermediateDataSetIdToConsume(IntermediateDataSetID intermediateDataSetId) {
        this.intermediateDataSetIdsToConsume.add(intermediateDataSetId);
    }

    public List<IntermediateDataSetID> getIntermediateDataSetIdsToConsume() {
        return this.intermediateDataSetIdsToConsume;
    }

    public String toString() {
        return this.name + " (" + this.invokableClassName + ')';
    }

    public static interface FinalizeOnMasterContext {
        public ClassLoader getClassLoader();

        public int getExecutionParallelism();

        public int getFinishedAttempt(int var1);
    }

    public static interface InitializeOnMasterContext {
        public ClassLoader getClassLoader();

        public int getExecutionParallelism();
    }
}

