/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filemerging.DirectoryStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.SegmentFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FileMergingCheckpointStateOutputStream;

public interface FileMergingSnapshotManager
extends Closeable {
    public void initFileSystem(FileSystem var1, Path var2, Path var3, Path var4, int var5) throws IllegalArgumentException;

    public void registerSubtaskForSharedStates(SubtaskKey var1);

    public void unregisterSubtask(SubtaskKey var1);

    public FileMergingCheckpointStateOutputStream createCheckpointStateOutputStream(SubtaskKey var1, long var2, CheckpointedStateScope var4);

    public Path getManagedDir(SubtaskKey var1, CheckpointedStateScope var2);

    public DirectoryStreamStateHandle getManagedDirStateHandle(SubtaskKey var1, CheckpointedStateScope var2);

    public void notifyCheckpointStart(SubtaskKey var1, long var2);

    public void notifyCheckpointComplete(SubtaskKey var1, long var2) throws Exception;

    public void notifyCheckpointAborted(SubtaskKey var1, long var2) throws Exception;

    public void notifyCheckpointSubsumed(SubtaskKey var1, long var2) throws Exception;

    public boolean couldReusePreviousStateHandle(StreamStateHandle var1);

    public void reusePreviousStateHandle(long var1, Collection<? extends StreamStateHandle> var3);

    public void restoreStateHandles(long var1, SubtaskKey var3, Stream<SegmentFileStateHandle> var4);

    public static boolean isFileMergingHandle(StreamStateHandle handle) {
        return handle instanceof SegmentFileStateHandle || handle instanceof PlaceholderStreamStateHandle && ((PlaceholderStreamStateHandle)handle).isFileMerged();
    }

    public static final class SpaceStat {
        AtomicLong physicalFileCount;
        AtomicLong physicalFileSize;
        AtomicLong logicalFileCount;
        AtomicLong logicalFileSize;

        public SpaceStat() {
            this(0L, 0L, 0L, 0L);
        }

        public SpaceStat(long physicalFileCount, long physicalFileSize, long logicalFileCount, long logicalFileSize) {
            this.physicalFileCount = new AtomicLong(physicalFileCount);
            this.physicalFileSize = new AtomicLong(physicalFileSize);
            this.logicalFileCount = new AtomicLong(logicalFileCount);
            this.logicalFileSize = new AtomicLong(logicalFileSize);
        }

        public void onLogicalFileCreate(long size) {
            this.logicalFileSize.addAndGet(size);
            this.logicalFileCount.incrementAndGet();
        }

        public void onLogicalFileDelete(long size) {
            this.logicalFileSize.addAndGet(-size);
            this.logicalFileCount.decrementAndGet();
        }

        public void onPhysicalFileUpdate(long size) {
            this.physicalFileSize.addAndGet(size);
        }

        public void onPhysicalFileCreate() {
            this.physicalFileCount.incrementAndGet();
        }

        public void onPhysicalFileDelete(long size) {
            this.physicalFileSize.addAndGet(-size);
            this.physicalFileCount.decrementAndGet();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpaceStat spaceStat = (SpaceStat)o;
            return this.physicalFileCount.get() == spaceStat.physicalFileCount.get() && this.physicalFileSize.get() == spaceStat.physicalFileSize.get() && this.logicalFileCount.get() == spaceStat.logicalFileCount.get() && this.logicalFileSize.get() == spaceStat.logicalFileSize.get();
        }

        public String toString() {
            return "SpaceStat{physicalFileCount=" + this.physicalFileCount.get() + ", physicalFileSize=" + this.physicalFileSize.get() + ", logicalFileCount=" + this.logicalFileCount.get() + ", logicalFileSize=" + this.logicalFileSize.get() + '}';
        }
    }

    public static final class SubtaskKey {
        private static final String MANAGED_DIR_FORMAT = "job_%s_op_%s_%d_%d";
        final String jobIDString;
        final String vertexIDString;
        final int subtaskIndex;
        final int parallelism;
        final int hashCode;

        public SubtaskKey(JobID jobID, JobVertexID vertexID, TaskInfo taskInfo) {
            this(jobID.toHexString(), vertexID.toHexString(), taskInfo.getIndexOfThisSubtask(), taskInfo.getNumberOfParallelSubtasks());
        }

        @VisibleForTesting
        public SubtaskKey(String jobIDString, String vertexIDString, int subtaskIndex, int parallelism) {
            this.jobIDString = jobIDString;
            this.vertexIDString = vertexIDString;
            this.subtaskIndex = subtaskIndex;
            this.parallelism = parallelism;
            int hash = jobIDString.hashCode();
            hash = 31 * hash + vertexIDString.hashCode();
            hash = 31 * hash + subtaskIndex;
            this.hashCode = hash = 31 * hash + parallelism;
        }

        public static SubtaskKey of(Environment environment) {
            return new SubtaskKey(environment.getJobID(), environment.getJobVertexId(), environment.getTaskInfo());
        }

        @VisibleForTesting
        public String getJobIDString() {
            return this.jobIDString;
        }

        public String getManagedDirName() {
            return String.format(MANAGED_DIR_FORMAT, this.jobIDString, this.vertexIDString, this.subtaskIndex, this.parallelism).replaceAll("[^a-zA-Z0-9\\-]", "_");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubtaskKey that = (SubtaskKey)o;
            return this.hashCode == that.hashCode && this.subtaskIndex == that.subtaskIndex && this.parallelism == that.parallelism && this.vertexIDString.equals(that.vertexIDString) && this.jobIDString.equals(that.jobIDString);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("%s-%s(%d/%d)", this.jobIDString, this.vertexIDString, this.subtaskIndex, this.parallelism);
        }
    }
}

