/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.taskexecutor.slot.DefaultTimerService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultTimerServiceTest {
    DefaultTimerServiceTest() {
    }

    @Test
    void testUnregisterAllTimeouts() {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        DefaultTimerService timerService = new DefaultTimerService((ScheduledExecutorService)scheduledExecutorService, 100L);
        timerService.start((ignoredA, ignoredB) -> {});
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.unregisterAllTimeouts();
        Map timeouts = timerService.getTimeouts();
        Assertions.assertThat((Map)timeouts).isEmpty();
        for (ScheduledFuture scheduledTask : scheduledExecutorService.getAllScheduledTasks()) {
            Assertions.assertThat((boolean)scheduledTask.isCancelled()).isTrue();
        }
    }

    @Test
    void testIsValidInitiallyReturnsFalse() {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        Assertions.assertThat((boolean)timerService.isValid((Object)new AllocationID(), UUID.randomUUID())).isFalse();
    }

    @Test
    void testIsValidReturnsTrueForActiveTimeout() throws Exception {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        AllocationID allocationId = new AllocationID();
        timerService.registerTimeout((Object)allocationId, 10L, TimeUnit.SECONDS);
        DefaultTimerService.Timeout timeout = (DefaultTimerService.Timeout)timerService.getTimeouts().get(allocationId);
        UUID ticket = timeout.getTicket();
        Assertions.assertThat((boolean)timerService.isValid((Object)allocationId, ticket)).isTrue();
    }

    @Test
    void testIsValidReturnsFalseIfEitherKeyOrTicketDoesNotMatch() {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        AllocationID allocationId = new AllocationID();
        timerService.registerTimeout((Object)allocationId, 10L, TimeUnit.SECONDS);
        DefaultTimerService.Timeout timeout = (DefaultTimerService.Timeout)timerService.getTimeouts().get(allocationId);
        UUID ticket = timeout.getTicket();
        Assertions.assertThat((boolean)timerService.isValid((Object)new AllocationID(), ticket)).isFalse();
        Assertions.assertThat((boolean)timerService.isValid((Object)allocationId, UUID.randomUUID())).isFalse();
    }

    private static DefaultTimerService<AllocationID> createAndStartTimerService() {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        DefaultTimerService timerService = new DefaultTimerService((ScheduledExecutorService)scheduledExecutorService, 100L);
        timerService.start((ignoredA, ignoredB) -> {});
        return timerService;
    }
}

