/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class MemoryStateBackendTest
extends StateBackendTestBase<MemoryStateBackend> {
    @Parameter
    public boolean useAsyncmode;

    @Parameters(name="useAsyncmode")
    public static List<Boolean> modes() {
        return Arrays.asList(true, false);
    }

    @Override
    protected ConfigurableStateBackend getStateBackend() {
        return new MemoryStateBackend(this.useAsyncmode);
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    protected boolean supportsAsynchronousSnapshots() {
        return this.useAsyncmode;
    }

    @Override
    @TestTemplate
    void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testMapStateRestoreWithWrongSerializers() {
    }

    @Override
    @Disabled
    @TestTemplate
    void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

