/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

public class TestSchedulingStrategy
implements SchedulingStrategy {
    private final SchedulerOperations schedulerOperations;
    private final SchedulingTopology schedulingTopology;
    private Set<ExecutionVertexID> receivedVerticesToRestart;

    public TestSchedulingStrategy(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
        this.schedulerOperations = (SchedulerOperations)Preconditions.checkNotNull((Object)schedulerOperations);
        this.schedulingTopology = (SchedulingTopology)Preconditions.checkNotNull((Object)schedulingTopology);
    }

    public void startScheduling() {
    }

    public void restartTasks(Set<ExecutionVertexID> verticesToRestart) {
        this.receivedVerticesToRestart = verticesToRestart;
    }

    public void onExecutionStateChange(ExecutionVertexID executionVertexId, ExecutionState executionState) {
    }

    public void onPartitionConsumable(IntermediateResultPartitionID resultPartitionId) {
    }

    public void schedule(List<ExecutionVertexID> verticesToSchedule) {
        this.allocateSlotsAndDeploy(verticesToSchedule);
    }

    public SchedulingTopology getSchedulingTopology() {
        return this.schedulingTopology;
    }

    public Set<ExecutionVertexID> getReceivedVerticesToRestart() {
        return this.receivedVerticesToRestart;
    }

    private void allocateSlotsAndDeploy(List<ExecutionVertexID> verticesToSchedule) {
        this.schedulerOperations.allocateSlotsAndDeploy(verticesToSchedule);
    }

    public static class Factory
    implements SchedulingStrategyFactory {
        private TestSchedulingStrategy lastInstance;

        public SchedulingStrategy createInstance(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
            this.lastInstance = new TestSchedulingStrategy(schedulerOperations, schedulingTopology);
            return this.lastInstance;
        }

        public TestSchedulingStrategy getLastCreatedSchedulingStrategy() {
            return this.lastInstance;
        }
    }
}

