/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionVertexInputInfo;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.event.ExecutionJobVertexInitializedEvent;
import org.apache.flink.runtime.jobmaster.event.GenericJobEventSerializer;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionJobVertexInitializedEventTest {
    ExecutionJobVertexInitializedEventTest() {
    }

    @Test
    void testSerializeExecutionJobVertexInitializedEvent() throws IOException {
        int parallelism = 4;
        HashMap<IntermediateDataSetID, JobVertexInputInfo> jobVertexInputInfos = new HashMap<IntermediateDataSetID, JobVertexInputInfo>();
        jobVertexInputInfos.put(new IntermediateDataSetID(), new JobVertexInputInfo(Collections.emptyList()));
        jobVertexInputInfos.put(new IntermediateDataSetID(), new JobVertexInputInfo(Collections.singletonList(new ExecutionVertexInputInfo(0, new IndexRange(0, 1), new IndexRange(0, 1)))));
        JobVertexID jobVertexId = new JobVertexID();
        ExecutionJobVertexInitializedEvent event = new ExecutionJobVertexInitializedEvent(jobVertexId, parallelism, jobVertexInputInfos);
        GenericJobEventSerializer serializer = new GenericJobEventSerializer();
        byte[] binary = serializer.serialize((JobEvent)event);
        ExecutionJobVertexInitializedEvent deserializeEvent = (ExecutionJobVertexInitializedEvent)serializer.deserialize(serializer.getVersion(), binary);
        Assertions.assertThat((Comparable)deserializeEvent.getJobVertexId()).isEqualTo((Object)jobVertexId);
        Assertions.assertThat((int)deserializeEvent.getParallelism()).isEqualTo(parallelism);
        Assertions.assertThat((Map)deserializeEvent.getJobVertexInputInfos()).isEqualTo(jobVertexInputInfos);
        Assertions.assertThat((int)deserializeEvent.getType()).isEqualTo(event.getType());
    }
}

