/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.FlinkException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobManagerRunnerResultTest {
    private final ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().build());
    private final FlinkException testException = new FlinkException("test exception");

    JobManagerRunnerResultTest() {
    }

    @Test
    void testSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        Assertions.assertThat((boolean)jobManagerRunnerResult.isSuccess()).isTrue();
        Assertions.assertThat((boolean)jobManagerRunnerResult.isInitializationFailure()).isFalse();
    }

    @Test
    void testInitializationFailureJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forInitializationFailure((ExecutionGraphInfo)this.executionGraphInfo, (Throwable)this.testException);
        Assertions.assertThat((boolean)jobManagerRunnerResult.isInitializationFailure()).isTrue();
        Assertions.assertThat((boolean)jobManagerRunnerResult.isSuccess()).isFalse();
    }

    @Test
    void testGetArchivedExecutionGraphFromSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        Assertions.assertThat((Object)jobManagerRunnerResult.getExecutionGraphInfo()).isEqualTo((Object)this.executionGraphInfo);
    }

    @Test
    void testGetInitializationFailureFromFailedJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forInitializationFailure((ExecutionGraphInfo)this.executionGraphInfo, (Throwable)this.testException);
        Assertions.assertThat((Throwable)jobManagerRunnerResult.getInitializationFailure()).isEqualTo((Object)this.testException);
    }

    @Test
    void testGetInitializationFailureFromSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        Assertions.assertThatThrownBy(() -> ((JobManagerRunnerResult)jobManagerRunnerResult).getInitializationFailure()).isInstanceOf(IllegalStateException.class);
    }
}

