/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SegmentPartitionFileTest {
    @TempDir
    File tempFolder;

    SegmentPartitionFileTest() {
    }

    @Test
    void testGetTieredStoragePath() {
        String tieredStoragePath = SegmentPartitionFile.getTieredStoragePath((String)this.tempFolder.getPath());
        Assertions.assertThat((String)tieredStoragePath).isEqualTo(new File(this.tempFolder.getPath(), "tiered-storage").getPath());
    }

    @Test
    void testGetPartitionPath() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        String partitionPath = SegmentPartitionFile.getPartitionPath((TieredStoragePartitionId)partitionId, (String)this.tempFolder.getPath());
        File partitionFile = new File(this.tempFolder.getPath(), TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId).toString());
        Assertions.assertThat((String)partitionPath).isEqualTo(partitionFile.getPath());
    }

    @Test
    void testGetSubpartitionPath() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        String subpartitionPath = SegmentPartitionFile.getSubpartitionPath((String)this.tempFolder.getPath(), (TieredStoragePartitionId)partitionId, (int)subpartitionId);
        File partitionFile = new File(this.tempFolder.getPath(), TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId).toString());
        Assertions.assertThat((String)subpartitionPath).isEqualTo(new File(partitionFile, String.valueOf(subpartitionId)).toString());
    }

    @Test
    void testGetSegmentPath() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 1;
        String segmentPath = SegmentPartitionFile.getSegmentPath((String)this.tempFolder.getPath(), (TieredStoragePartitionId)partitionId, (int)subpartitionId, (long)segmentId).toString();
        File partitionFile = new File(this.tempFolder.getPath(), TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId).toString());
        File subpartitionFile = new File(partitionFile, String.valueOf(subpartitionId));
        Assertions.assertThat((String)segmentPath).isEqualTo(new File(subpartitionFile, "seg-" + segmentId).toString());
    }

    @Test
    void testGetSegmentFinishDirPath() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        String segmentFinishDirPath = SegmentPartitionFile.getSegmentFinishDirPath((String)this.tempFolder.getPath(), (TieredStoragePartitionId)partitionId, (int)subpartitionId).getPath();
        File expectedSegmentFinishDir = SegmentPartitionFileTest.getSegmentFinishDir(this.tempFolder.getPath(), partitionId, subpartitionId);
        Assertions.assertThat((String)segmentFinishDirPath).isEqualTo(expectedSegmentFinishDir.getPath());
    }

    @Test
    void testWriteBuffers() throws IOException {
        Random random = new Random();
        int numBuffers = 20;
        int bufferSizeBytes = 10;
        File testFile = new File(this.tempFolder.getPath(), "testFile");
        Path testPath = Path.fromLocalFile((File)testFile);
        FileSystem fs = testPath.getFileSystem();
        WritableByteChannel currentChannel = Channels.newChannel((OutputStream)fs.create(testPath, FileSystem.WriteMode.NO_OVERWRITE));
        ByteBuffer[] toWriteBuffers = new ByteBuffer[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            byte[] bytes = new byte[bufferSizeBytes];
            random.nextBytes(bytes);
            toWriteBuffers[i] = ByteBuffer.wrap(bytes);
        }
        int numExpectedBytes = numBuffers * bufferSizeBytes;
        SegmentPartitionFile.writeBuffers((WritableByteChannel)currentChannel, (long)numExpectedBytes, (ByteBuffer[])toWriteBuffers);
        byte[] bytesRead = Files.readAllBytes(testFile.toPath());
        Assertions.assertThat((byte[])bytesRead).hasSize(numExpectedBytes);
    }

    @Test
    void testWriteSegmentFinishFile() throws IOException {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 1;
        int newSegmentId = 5;
        SegmentPartitionFileTest.writeAndCheckSegmentFinishFile(this.tempFolder.getPath(), partitionId, subpartitionId, segmentId);
        SegmentPartitionFileTest.writeAndCheckSegmentFinishFile(this.tempFolder.getPath(), partitionId, subpartitionId, newSegmentId);
    }

    @Test
    void testDeletePathQuietly() throws IOException {
        File testFile = new File(this.tempFolder.getPath(), "testFile");
        Files.createFile(testFile.toPath(), new FileAttribute[0]);
        Assertions.assertThat((File)testFile).exists();
        SegmentPartitionFile.deletePathQuietly((String)testFile.getPath());
        Assertions.assertThat((File)testFile).doesNotExist();
    }

    private static void writeAndCheckSegmentFinishFile(String baseDir, TieredStoragePartitionId partitionId, int subpartitionId, int segmentId) throws IOException {
        SegmentPartitionFile.writeSegmentFinishFile((String)baseDir, (TieredStoragePartitionId)partitionId, (int)subpartitionId, (int)segmentId);
        File segmentFinishDir = SegmentPartitionFileTest.getSegmentFinishDir(baseDir, partitionId, subpartitionId);
        Assertions.assertThat((boolean)segmentFinishDir.isDirectory()).isTrue();
        Object[] segmentFinishFiles = segmentFinishDir.listFiles();
        Assertions.assertThat((Object[])segmentFinishFiles).hasSize(1);
        Assertions.assertThat((File)segmentFinishFiles[0]).isFile();
        Assertions.assertThat((String)((File)segmentFinishFiles[0]).getName()).isEqualTo(String.valueOf(segmentId));
    }

    private static File getSegmentFinishDir(String baseDir, TieredStoragePartitionId partitionId, int subpartitionId) {
        File partitionFile = new File(baseDir, TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId).toString());
        File subpartitionFile = new File(partitionFile, String.valueOf(subpartitionId));
        return new File(subpartitionFile, "FINISH");
    }
}

