/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.ResourceBudgetManager;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceBudgetManagerTest {
    @Test
    void testReserve() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assertions.assertThat((boolean)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70))).isEqualTo(true);
        Assertions.assertThat((Object)budgetManager.getAvailableBudget()).isEqualTo((Object)ResourceBudgetManagerTest.createResourceProfile(0.3, 30));
    }

    @Test
    void testReserveFail() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assertions.assertThat((boolean)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(1.2, 120))).isEqualTo(false);
        Assertions.assertThat((Object)budgetManager.getAvailableBudget()).isEqualTo((Object)ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
    }

    @Test
    void testRelease() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assertions.assertThat((boolean)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70))).isEqualTo(true);
        Assertions.assertThat((boolean)budgetManager.release(ResourceBudgetManagerTest.createResourceProfile(0.5, 50))).isEqualTo(true);
        Assertions.assertThat((Object)budgetManager.getAvailableBudget()).isEqualTo((Object)ResourceBudgetManagerTest.createResourceProfile(0.8, 80));
    }

    @Test
    void testReleaseFail() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assertions.assertThat((boolean)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70))).isEqualTo(true);
        Assertions.assertThat((boolean)budgetManager.release(ResourceBudgetManagerTest.createResourceProfile(0.8, 80))).isEqualTo(false);
        Assertions.assertThat((Object)budgetManager.getAvailableBudget()).isEqualTo((Object)ResourceBudgetManagerTest.createResourceProfile(0.3, 30));
    }

    private static ResourceProfile createResourceProfile(double cpus, int memory) {
        return ResourceProfile.newBuilder().setCpuCores(cpus).setTaskHeapMemory(MemorySize.ofMebiBytes((long)memory)).build();
    }
}

