/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InflightDataRescalingDescriptorTest {
    InflightDataRescalingDescriptorTest() {
    }

    @Test
    void testNoStateDescriptorThrowsOnGetOldSubtaskInstances() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor)noStateDescriptor).getOldSubtaskInstances()).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot get old subtasks from a descriptor that represents no state");
    }

    @Test
    void testNoStateDescriptorThrowsOnGetRescaleMappings() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor)noStateDescriptor).getRescaleMappings()).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot get rescale mappings from a descriptor that represents no state");
    }

    @Test
    void testNoStateDescriptorIsIdentity() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        Assertions.assertThat((boolean)noStateDescriptor.isIdentity()).isTrue();
    }

    @Test
    void testRegularDescriptorDoesNotThrow() {
        int[] oldSubtasks = new int[]{0, 1, 2};
        RescaleMappings mappings = RescaleMappings.of(Arrays.stream(new int[][]{{0}, {1}, {2}}), (int)3);
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor descriptor = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(oldSubtasks, mappings, Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.RESCALING);
        Assertions.assertThat((int[])descriptor.getOldSubtaskInstances()).isEqualTo((Object)oldSubtasks);
        Assertions.assertThat((Object)descriptor.getRescaleMappings()).isEqualTo((Object)mappings);
        Assertions.assertThat((boolean)descriptor.isIdentity()).isFalse();
    }

    @Test
    void testIdentityDescriptor() {
        int[] oldSubtasks = new int[]{0};
        RescaleMappings mappings = RescaleMappings.identity((int)1, (int)1);
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor descriptor = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(oldSubtasks, mappings, Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.IDENTITY);
        Assertions.assertThat((boolean)descriptor.isIdentity()).isTrue();
        Assertions.assertThat((int[])descriptor.getOldSubtaskInstances()).isEqualTo((Object)oldSubtasks);
        Assertions.assertThat((Object)descriptor.getRescaleMappings()).isEqualTo((Object)mappings);
    }

    @Test
    void testInflightDataRescalingDescriptorWithNoStateDescriptor() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[] descriptors = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[]{InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE, new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(new int[]{0, 1}, RescaleMappings.of(Arrays.stream(new int[][]{{0}, {1}}), (int)2), Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.RESCALING)};
        InflightDataRescalingDescriptor rescalingDescriptor = new InflightDataRescalingDescriptor(descriptors);
        Assertions.assertThatThrownBy(() -> rescalingDescriptor.getOldSubtaskIndexes(0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> rescalingDescriptor.getChannelMapping(0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThat((int[])rescalingDescriptor.getOldSubtaskIndexes(1)).isEqualTo((Object)new int[]{0, 1});
        Assertions.assertThat((Object)rescalingDescriptor.getChannelMapping(1)).isNotNull();
    }
}

