/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.ConfigurationInfo;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class ClusterConfigHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, ConfigurationInfo, EmptyMessageParameters> {
    private final ConfigurationInfo clusterConfig;

    public ClusterConfigHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, ConfigurationInfo, EmptyMessageParameters> messageHeaders, Configuration configuration) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        Preconditions.checkNotNull((Object)configuration);
        this.clusterConfig = ConfigurationInfo.from(configuration);
    }

    @Override
    protected CompletableFuture<ConfigurationInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        return CompletableFuture.completedFuture(this.clusterConfig);
    }
}

