/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.InitializationStatus;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;

@NotThreadSafe
public class SubTaskInitializationMetricsBuilder {
    private final long initializationStartTs;
    private final Map<String, Long> durationMetrics = new HashMap<String, Long>();
    private InitializationStatus status = InitializationStatus.FAILED;

    public SubTaskInitializationMetricsBuilder(long initializationStartTs) {
        this.initializationStartTs = initializationStartTs;
    }

    public long getInitializationStartTs() {
        return this.initializationStartTs;
    }

    public SubTaskInitializationMetricsBuilder addDurationMetric(String name, long value) {
        this.durationMetrics.compute(name, (key, oldValue) -> oldValue == null ? value : value + oldValue);
        return this;
    }

    public SubTaskInitializationMetricsBuilder setStatus(InitializationStatus status) {
        this.status = status;
        return this;
    }

    public SubTaskInitializationMetrics build() {
        return this.build(System.currentTimeMillis());
    }

    @VisibleForTesting
    public SubTaskInitializationMetrics build(long endTs) {
        return new SubTaskInitializationMetrics(this.initializationStartTs, endTs, this.durationMetrics, this.status);
    }
}

