/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyGroupsStateHandleTest {
    KeyGroupsStateHandleTest() {
    }

    @Test
    void testNonEmptyIntersection() {
        KeyGroupRangeOffsets offsets = new KeyGroupRangeOffsets(0, 7);
        byte[] dummy = new byte[10];
        ByteStreamStateHandle streamHandle = new ByteStreamStateHandle("test", dummy);
        KeyGroupsStateHandle handle = new KeyGroupsStateHandle(offsets, (StreamStateHandle)streamHandle);
        KeyGroupRange expectedRange = new KeyGroupRange(0, 3);
        KeyGroupsStateHandle newHandle = handle.getIntersection(expectedRange);
        Assertions.assertThat((Object)newHandle).isNotNull();
        Assertions.assertThat((Object)newHandle.getDelegateStateHandle()).isEqualTo((Object)streamHandle);
        Assertions.assertThat((Iterable)newHandle.getKeyGroupRange()).isEqualTo((Object)expectedRange);
        Assertions.assertThat((Object)newHandle.getStateHandleId()).isEqualTo((Object)handle.getStateHandleId());
    }

    @Test
    void testEmptyIntersection() {
        KeyGroupRangeOffsets offsets = new KeyGroupRangeOffsets(0, 7);
        byte[] dummy = new byte[10];
        ByteStreamStateHandle streamHandle = new ByteStreamStateHandle("test", dummy);
        KeyGroupsStateHandle handle = new KeyGroupsStateHandle(offsets, (StreamStateHandle)streamHandle);
        KeyGroupRange newRange = new KeyGroupRange(8, 11);
        Assertions.assertThat((Object)handle.getIntersection(newRange)).isNull();
    }

    @Test
    void testCollectSizeStats() {
        KeyGroupRangeOffsets offsets = new KeyGroupRangeOffsets(0, 7);
        final byte[] data = new byte[5];
        ByteStreamStateHandle innerHandle = new ByteStreamStateHandle("name", data);
        KeyGroupsStateHandle handle = new KeyGroupsStateHandle(offsets, (StreamStateHandle)innerHandle);
        StateObject.StateObjectSizeStatsCollector statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        handle.collectSizeStats(statsCollector);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HashMap<StateObject.StateObjectLocation, Long>(){
            {
                this.put(StateObject.StateObjectLocation.LOCAL_MEMORY, Long.valueOf(data.length));
            }
        }, (Object)statsCollector.getStats());
    }
}

