/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RestMatchers {
    public static <T> Matcher<CompletableFuture<T>> respondsWithError(HttpResponseStatus responseStatus) {
        return new ErrorResponseStatusCodeMatcher(responseStatus);
    }

    private static final class ErrorResponseStatusCodeMatcher<T>
    extends TypeSafeDiagnosingMatcher<CompletableFuture<T>> {
        private final HttpResponseStatus expectedErrorResponse;

        ErrorResponseStatusCodeMatcher(HttpResponseStatus expectedErrorResponse) {
            this.expectedErrorResponse = expectedErrorResponse;
        }

        protected boolean matchesSafely(CompletableFuture<T> future, Description mismatchDescription) {
            try {
                future.get();
                mismatchDescription.appendText("The request succeeded");
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error("interrupted test");
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && RestHandlerException.class.isAssignableFrom(e.getCause().getClass())) {
                    RestHandlerException rhe = (RestHandlerException)e.getCause();
                    if (rhe.getHttpResponseStatus() == this.expectedErrorResponse) {
                        return true;
                    }
                    mismatchDescription.appendText("Error response had different status code: " + rhe.getHttpResponseStatus());
                    return false;
                }
                mismatchDescription.appendText("Future completed with different exception: " + e.getCause());
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("An error response with status code: " + this.expectedErrorResponse);
        }
    }
}

