/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.BiDirectionalResourceToRequirementMapping;
import org.apache.flink.runtime.util.ResourceCounter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BiDirectionalResourceToRequirementMappingTest {
    BiDirectionalResourceToRequirementMappingTest() {
    }

    @Test
    void testIncrement() {
        BiDirectionalResourceToRequirementMapping mapping = new BiDirectionalResourceToRequirementMapping();
        ResourceProfile requirement = ResourceProfile.UNKNOWN;
        ResourceProfile resource = ResourceProfile.ANY;
        mapping.incrementCount(requirement, resource, 1);
        Assertions.assertThat((Object)mapping.getRequirementsFulfilledBy(resource)).isEqualTo((Object)ResourceCounter.withResource((ResourceProfile)requirement, (int)1));
        Assertions.assertThat((Object)mapping.getResourcesFulfilling(requirement)).isEqualTo((Object)ResourceCounter.withResource((ResourceProfile)resource, (int)1));
        Assertions.assertThat((Collection)mapping.getAllRequirementProfiles()).contains((Object[])new ResourceProfile[]{requirement});
        Assertions.assertThat((Collection)mapping.getAllResourceProfiles()).contains((Object[])new ResourceProfile[]{resource});
    }

    @Test
    void testDecrement() {
        BiDirectionalResourceToRequirementMapping mapping = new BiDirectionalResourceToRequirementMapping();
        ResourceProfile requirement = ResourceProfile.UNKNOWN;
        ResourceProfile resource = ResourceProfile.ANY;
        mapping.incrementCount(requirement, resource, 1);
        mapping.decrementCount(requirement, resource, 1);
        Assertions.assertThat((boolean)mapping.getRequirementsFulfilledBy(resource).isEmpty()).isTrue();
        Assertions.assertThat((boolean)mapping.getResourcesFulfilling(requirement).isEmpty()).isTrue();
        Assertions.assertThat((Collection)mapping.getAllRequirementProfiles()).isEmpty();
        Assertions.assertThat((Collection)mapping.getAllResourceProfiles()).isEmpty();
        Assertions.assertThat((boolean)mapping.isEmpty()).isTrue();
    }
}

