/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.FlinkException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class SlotPoolUtils {
    public static final Time TIMEOUT = Time.seconds((long)10L);

    private SlotPoolUtils() {
        throw new UnsupportedOperationException("Cannot instantiate this class.");
    }

    public static DeclarativeSlotPoolBridge createDeclarativeSlotPoolBridge() {
        return new DeclarativeSlotPoolBridgeBuilder().build();
    }

    public static CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, ResourceProfile resourceProfile) {
        return CompletableFuture.supplyAsync(() -> slotPool.requestNewAllocatedBatchSlot(new SlotRequestId(), resourceProfile), (Executor)mainThreadExecutor).thenCompose(Function.identity());
    }

    public static ResourceID offerSlots(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles) {
        return SlotPoolUtils.offerSlots(slotPool, mainThreadExecutor, resourceProfiles, new SimpleAckingTaskManagerGateway());
    }

    public static ResourceID tryOfferSlots(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles) {
        return SlotPoolUtils.offerSlots(slotPool, mainThreadExecutor, resourceProfiles, new SimpleAckingTaskManagerGateway(), false);
    }

    public static ResourceID offerSlots(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles, TaskManagerGateway taskManagerGateway) {
        return SlotPoolUtils.offerSlots(slotPool, mainThreadExecutor, resourceProfiles, taskManagerGateway, true);
    }

    private static ResourceID offerSlots(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles, TaskManagerGateway taskManagerGateway, boolean assertAllSlotsAreAccepted) {
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        CompletableFuture.runAsync(() -> {
            slotPool.registerTaskManager(taskManagerLocation.getResourceID());
            Collection slotOffers = IntStream.range(0, resourceProfiles.size()).mapToObj(i -> new SlotOffer(new AllocationID(), i, (ResourceProfile)resourceProfiles.get(i))).collect(Collectors.toList());
            Collection acceptedOffers = slotPool.offerSlots(taskManagerLocation, taskManagerGateway, slotOffers);
            if (assertAllSlotsAreAccepted) {
                MatcherAssert.assertThat((Object)acceptedOffers, (Matcher)Matchers.is((Object)slotOffers));
            }
        }, (Executor)mainThreadExecutor).join();
        return taskManagerLocation.getResourceID();
    }

    public static void releaseTaskManager(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, ResourceID taskManagerResourceId) {
        CompletableFuture.runAsync(() -> slotPool.releaseTaskManager(taskManagerResourceId, (Exception)new FlinkException("Let's get rid of the offered slot.")), (Executor)mainThreadExecutor).join();
    }

    public static void notifyNotEnoughResourcesAvailable(SlotPoolService slotPoolService, ComponentMainThreadExecutor mainThreadExecutor, Collection<ResourceRequirement> acquiredResources) {
        CompletableFuture.runAsync(() -> slotPoolService.notifyNotEnoughResourcesAvailable(acquiredResources), (Executor)mainThreadExecutor).join();
    }

    static ResourceCounter calculateResourceCounter(ResourceProfile[] resourceProfiles) {
        Map resources = Arrays.stream(resourceProfiles).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum)));
        ResourceCounter increment = ResourceCounter.withResources(resources);
        return increment;
    }
}

