/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.security.token.DelegationTokenReceiver;
import org.apache.flink.runtime.security.token.DefaultDelegationTokenManager;
import org.apache.flink.runtime.security.token.DelegationTokenContainer;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DelegationTokenReceiverRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenReceiverRepository.class);
    private final Configuration configuration;
    @Nullable
    private final PluginManager pluginManager;
    @VisibleForTesting
    final Map<String, DelegationTokenReceiver> delegationTokenReceivers;

    public DelegationTokenReceiverRepository(Configuration configuration, @Nullable PluginManager pluginManager) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration, (String)"Flink configuration must not be null");
        this.pluginManager = pluginManager;
        this.delegationTokenReceivers = this.loadReceivers();
    }

    private Map<String, DelegationTokenReceiver> loadReceivers() {
        LOG.info("Loading delegation token receivers");
        HashMap<String, DelegationTokenReceiver> receivers = new HashMap<String, DelegationTokenReceiver>();
        Consumer<DelegationTokenReceiver> loadReceiver = receiver -> {
            try {
                if (DefaultDelegationTokenManager.isProviderEnabled(this.configuration, receiver.serviceName())) {
                    receiver.init(this.configuration);
                    LOG.info("Delegation token receiver {} loaded and initialized", (Object)receiver.serviceName());
                    Preconditions.checkState((!receivers.containsKey(receiver.serviceName()) ? 1 : 0) != 0, (String)"Delegation token receiver with service name {} has multiple implementations", (Object[])new Object[]{receiver.serviceName()});
                    receivers.put(receiver.serviceName(), (DelegationTokenReceiver)receiver);
                } else {
                    LOG.info("Delegation token receiver {} is disabled so not loaded", (Object)receiver.serviceName());
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                LOG.error("Failed to initialize delegation token receiver {}", (Object)receiver.serviceName(), (Object)e);
                throw new FlinkRuntimeException(e);
            }
        };
        ServiceLoader.load(DelegationTokenReceiver.class).iterator().forEachRemaining(loadReceiver);
        if (this.pluginManager != null) {
            this.pluginManager.load(DelegationTokenReceiver.class).forEachRemaining(loadReceiver);
        }
        LOG.info("Delegation token receivers loaded successfully");
        return receivers;
    }

    @VisibleForTesting
    boolean isReceiverLoaded(String serviceName) {
        return this.delegationTokenReceivers.containsKey(serviceName);
    }

    public void onNewTokensObtained(byte[] containerBytes) throws Exception {
        if (containerBytes == null || containerBytes.length == 0) {
            throw new IllegalArgumentException("Illegal container tried to be processed");
        }
        DelegationTokenContainer container = (DelegationTokenContainer)InstantiationUtil.deserializeObject((byte[])containerBytes, (ClassLoader)DelegationTokenContainer.class.getClassLoader());
        this.onNewTokensObtained(container);
    }

    public void onNewTokensObtained(DelegationTokenContainer container) throws Exception {
        LOG.info("New delegation tokens arrived, sending them to receivers");
        for (Map.Entry<String, byte[]> entry : container.getTokens().entrySet()) {
            String serviceName = entry.getKey();
            byte[] tokens = entry.getValue();
            if (!this.delegationTokenReceivers.containsKey(serviceName)) {
                throw new IllegalStateException("Tokens arrived for service but no receiver found for it: " + serviceName);
            }
            try {
                this.delegationTokenReceivers.get(serviceName).onNewTokensObtained(tokens);
            }
            catch (Exception e) {
                LOG.warn("Failed to send tokens to delegation token receiver {}", (Object)serviceName, (Object)e);
            }
        }
        LOG.info("Delegation tokens sent to receivers");
    }
}

