/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.rescaling;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AbstractAsynchronousOperationHandlers;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusMessageParameters;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class RescalingHandlers
extends AbstractAsynchronousOperationHandlers<AsynchronousJobOperationKey, Acknowledge> {
    public RescalingHandlers(Duration cacheDuration) {
        super(cacheDuration);
    }

    private static RestHandlerException featureDisabledException() {
        return new RestHandlerException("Rescaling is temporarily disabled. See FLINK-12312.", HttpResponseStatus.SERVICE_UNAVAILABLE);
    }

    public class RescalingStatusHandler
    extends AbstractAsynchronousOperationHandlers.StatusHandler<RestfulGateway, AsynchronousOperationInfo, RescalingStatusMessageParameters> {
        public RescalingStatusHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(leaderRetriever, timeout, responseHeaders, RescalingStatusHeaders.getInstance());
        }

        @Override
        public CompletableFuture<AsynchronousOperationResult<AsynchronousOperationInfo>> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            throw RescalingHandlers.featureDisabledException();
        }

        @Override
        protected AsynchronousJobOperationKey getOperationKey(HandlerRequest<EmptyRequestBody> request) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AsynchronousOperationInfo exceptionalOperationResultResponse(Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AsynchronousOperationInfo operationResultResponse(Acknowledge operationResult) {
            throw new UnsupportedOperationException();
        }
    }

    public class RescalingTriggerHandler
    extends AbstractAsynchronousOperationHandlers.TriggerHandler<RestfulGateway, EmptyRequestBody, RescalingTriggerMessageParameters> {
        public RescalingTriggerHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(leaderRetriever, timeout, responseHeaders, RescalingTriggerHeaders.getInstance());
        }

        @Override
        public CompletableFuture<TriggerResponse> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            throw RescalingHandlers.featureDisabledException();
        }

        @Override
        protected CompletableFuture<Acknowledge> triggerOperation(HandlerRequest<EmptyRequestBody> request, RestfulGateway gateway) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AsynchronousJobOperationKey createOperationKey(HandlerRequest<EmptyRequestBody> request) {
            throw new UnsupportedOperationException();
        }
    }
}

