/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

public class FineGrainedTaskManagerRegistration
implements TaskManagerInfo {
    private final TaskExecutorConnection taskManagerConnection;
    private final Map<AllocationID, FineGrainedTaskManagerSlot> slots;
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResource;
    private final int defaultNumSlots;
    private ResourceProfile unusedResource;
    private ResourceProfile pendingResource = ResourceProfile.ZERO;
    private long idleSince;

    public FineGrainedTaskManagerRegistration(TaskExecutorConnection taskManagerConnection, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        this.taskManagerConnection = (TaskExecutorConnection)Preconditions.checkNotNull((Object)taskManagerConnection);
        this.totalResource = (ResourceProfile)Preconditions.checkNotNull((Object)totalResourceProfile);
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.slots = new HashMap<AllocationID, FineGrainedTaskManagerSlot>();
        this.defaultNumSlots = SlotManagerUtils.calculateDefaultNumSlots(totalResourceProfile, defaultSlotResourceProfile);
        this.unusedResource = ResourceProfile.newBuilder(totalResourceProfile).build();
        this.idleSince = System.currentTimeMillis();
    }

    @Override
    public TaskExecutorConnection getTaskExecutorConnection() {
        return this.taskManagerConnection;
    }

    @Override
    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    @Override
    public Map<AllocationID, TaskManagerSlotInformation> getAllocatedSlots() {
        return Collections.unmodifiableMap(this.slots);
    }

    @Override
    public ResourceProfile getAvailableResource() {
        if (!this.unusedResource.allFieldsNoLessThan(this.pendingResource)) {
            return ResourceProfile.ZERO;
        }
        return this.unusedResource.subtract(this.pendingResource);
    }

    @Override
    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    @Override
    public ResourceProfile getTotalResource() {
        return this.totalResource;
    }

    @Override
    public int getDefaultNumSlots() {
        return this.defaultNumSlots;
    }

    @Override
    public long getIdleSince() {
        return this.idleSince;
    }

    @Override
    public boolean isIdle() {
        return this.idleSince != Long.MAX_VALUE;
    }

    public void freeSlot(AllocationID allocationId) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        FineGrainedTaskManagerSlot taskManagerSlot = (FineGrainedTaskManagerSlot)Preconditions.checkNotNull((Object)this.slots.remove((Object)allocationId));
        if (taskManagerSlot.getState() == SlotState.PENDING) {
            this.pendingResource = this.pendingResource.subtract(taskManagerSlot.getResourceProfile());
        } else {
            this.unusedResource = this.unusedResource.merge(taskManagerSlot.getResourceProfile());
        }
        if (this.slots.isEmpty()) {
            this.idleSince = System.currentTimeMillis();
        }
    }

    public void notifyAllocationComplete(AllocationID allocationId) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        FineGrainedTaskManagerSlot slot = (FineGrainedTaskManagerSlot)Preconditions.checkNotNull((Object)this.slots.get((Object)allocationId));
        Preconditions.checkState((slot.getState() == SlotState.PENDING ? 1 : 0) != 0);
        slot.completeAllocation();
        this.pendingResource = this.pendingResource.subtract(slot.getResourceProfile());
        this.unusedResource = this.unusedResource.subtract(slot.getResourceProfile());
    }

    public void notifyAllocation(AllocationID allocationId, FineGrainedTaskManagerSlot taskManagerSlot) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        Preconditions.checkNotNull((Object)taskManagerSlot);
        switch (taskManagerSlot.getState()) {
            case PENDING: {
                ResourceProfile newPendingResource = this.pendingResource.merge(taskManagerSlot.getResourceProfile());
                Preconditions.checkState((boolean)this.totalResource.allFieldsNoLessThan(newPendingResource));
                this.pendingResource = newPendingResource;
                break;
            }
            case ALLOCATED: {
                this.unusedResource = this.unusedResource.subtract(taskManagerSlot.getResourceProfile());
                break;
            }
            default: {
                throw new IllegalStateException("The slot stat should not be FREE under fine-grained resource management.");
            }
        }
        this.slots.put(allocationId, taskManagerSlot);
        this.idleSince = Long.MAX_VALUE;
    }
}

