/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TraceOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.filter.DefaultMetricFilter;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.traces.reporter.TraceReporter;
import org.apache.flink.traces.reporter.TraceReporterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TraceReporterSetup {
    private static final Logger LOG = LoggerFactory.getLogger(TraceReporterSetup.class);
    private static final Pattern traceReporterListPattern = Pattern.compile("\\s*,\\s*");
    private static final Pattern traceReporterClassPattern = Pattern.compile(Pattern.quote("traces.reporter.") + "([\\S&&[^.]]*)\\." + Pattern.quote(TraceOptions.REPORTER_FACTORY_CLASS.key()));
    private final String name;
    private final MetricConfig configuration;
    private final TraceReporter reporter;
    private final Map<String, String> additionalVariables;

    public TraceReporterSetup(String name, MetricConfig configuration, TraceReporter reporter, Map<String, String> additionalVariables) {
        this.name = name;
        this.configuration = configuration;
        this.reporter = reporter;
        this.additionalVariables = additionalVariables;
    }

    public Map<String, String> getAdditionalVariables() {
        return this.additionalVariables;
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    MetricConfig getConfiguration() {
        return this.configuration;
    }

    public TraceReporter getReporter() {
        return this.reporter;
    }

    @VisibleForTesting
    public static TraceReporterSetup forReporter(String reporterName, TraceReporter reporter) {
        return TraceReporterSetup.createReporterSetup(reporterName, new MetricConfig(), reporter, Collections.emptyMap());
    }

    @VisibleForTesting
    public static TraceReporterSetup forReporter(String reporterName, MetricConfig metricConfig, TraceReporter reporter) {
        return TraceReporterSetup.createReporterSetup(reporterName, metricConfig, reporter, Collections.emptyMap());
    }

    private static TraceReporterSetup createReporterSetup(String reporterName, MetricConfig metricConfig, TraceReporter reporter, Map<String, String> additionalVariables) {
        reporter.open(metricConfig);
        return new TraceReporterSetup(reporterName, metricConfig, reporter, additionalVariables);
    }

    public static List<TraceReporterSetup> fromConfiguration(Configuration configuration, @Nullable PluginManager pluginManager) {
        String includedReportersString = (String)configuration.get(TraceOptions.TRACE_REPORTERS_LIST, (Object)"");
        Set<String> namedReporters = ReporterSetup.findEnabledTraceReportersInConfiguration(configuration, includedReportersString, traceReporterListPattern, traceReporterClassPattern, "traces.reporter.");
        if (namedReporters.isEmpty()) {
            return Collections.emptyList();
        }
        List<Tuple2<String, Configuration>> reporterConfigurations = ReporterSetup.loadReporterConfigurations(configuration, namedReporters, "traces.reporter.");
        Map<String, TraceReporterFactory> reporterFactories = TraceReporterSetup.loadAvailableReporterFactories(pluginManager);
        return TraceReporterSetup.setupReporters(reporterFactories, reporterConfigurations);
    }

    private static Map<String, TraceReporterFactory> loadAvailableReporterFactories(@Nullable PluginManager pluginManager) {
        HashMap<String, TraceReporterFactory> reporterFactories = new HashMap<String, TraceReporterFactory>(2);
        Iterator<TraceReporterFactory> factoryIterator = TraceReporterSetup.getAllReporterFactories(pluginManager);
        while (factoryIterator.hasNext()) {
            try {
                TraceReporterFactory factory = factoryIterator.next();
                String factoryClassName = factory.getClass().getName();
                TraceReporterFactory existingFactory = (TraceReporterFactory)reporterFactories.get(factoryClassName);
                if (existingFactory == null) {
                    reporterFactories.put(factoryClassName, factory);
                    LOG.debug("Found {} {} at {} ", new Object[]{TraceReporterFactory.class.getSimpleName(), factoryClassName, new File(factory.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalPath()});
                    continue;
                }
                LOG.warn("Multiple implementations of the same {} were found in 'lib' and/or 'plugins' directories for {}. It is recommended to remove redundant reporter JARs to resolve used versions' ambiguity.", (Object)TraceReporter.class.getSimpleName(), (Object)factoryClassName);
            }
            catch (Exception | ServiceConfigurationError e) {
                LOG.warn("Error while loading {}.", (Object)TraceReporterFactory.class.getSimpleName(), (Object)e);
            }
        }
        return Collections.unmodifiableMap(reporterFactories);
    }

    private static Iterator<TraceReporterFactory> getAllReporterFactories(@Nullable PluginManager pluginManager) {
        Spliterator factoryIteratorSPI = ServiceLoader.load(TraceReporterFactory.class).spliterator();
        Spliterator factoryIteratorPlugins = pluginManager != null ? Spliterators.spliteratorUnknownSize(pluginManager.load(TraceReporterFactory.class), 0) : Collections.emptyList().spliterator();
        return Stream.concat(StreamSupport.stream(factoryIteratorPlugins, false), StreamSupport.stream(factoryIteratorSPI, false)).iterator();
    }

    private static List<TraceReporterSetup> setupReporters(Map<String, TraceReporterFactory> reporterFactories, List<Tuple2<String, Configuration>> reporterConfigurations) {
        ArrayList<TraceReporterSetup> reporterSetups = new ArrayList<TraceReporterSetup>(reporterConfigurations.size());
        for (Tuple2<String, Configuration> reporterConfiguration : reporterConfigurations) {
            String reporterName = (String)reporterConfiguration.f0;
            Configuration reporterConfig = (Configuration)reporterConfiguration.f1;
            try {
                Optional<TraceReporter> metricReporterOptional = TraceReporterSetup.loadReporter(reporterName, reporterConfig, reporterFactories);
                MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration(reporterConfig);
                Map<String, String> additionalVariables = ((Map)reporterConfig.get(TraceOptions.REPORTER_ADDITIONAL_VARIABLES)).entrySet().stream().collect(Collectors.toMap(e -> ScopeFormat.asVariable((String)e.getKey()), Map.Entry::getValue));
                metricReporterOptional.ifPresent(reporter -> {
                    MetricConfig metricConfig = new MetricConfig();
                    reporterConfig.addAllToProperties((Properties)metricConfig);
                    reporterSetups.add(TraceReporterSetup.createReporterSetup(reporterName, metricConfig, reporter, additionalVariables));
                });
            }
            catch (Throwable t) {
                LOG.error("Could not instantiate {} {}. Metrics might not be exposed/reported.", new Object[]{TraceReporter.class.getSimpleName(), reporterName, t});
            }
        }
        return reporterSetups;
    }

    private static Optional<TraceReporter> loadReporter(String reporterName, Configuration reporterConfig, Map<String, TraceReporterFactory> reporterFactories) {
        String factoryClassName = (String)reporterConfig.get(TraceOptions.REPORTER_FACTORY_CLASS);
        if (factoryClassName != null) {
            return TraceReporterSetup.loadViaFactory(factoryClassName, reporterName, reporterConfig, reporterFactories);
        }
        LOG.warn("No reporter factory set for reporter {}. Traces might not be exposed/reported.", (Object)reporterName);
        return Optional.empty();
    }

    private static Optional<TraceReporter> loadViaFactory(String factoryClassName, String reporterName, Configuration reporterConfig, Map<String, TraceReporterFactory> reporterFactories) {
        TraceReporterFactory factory = reporterFactories.get(factoryClassName);
        if (factory == null) {
            LOG.warn("The reporter factory ({}) could not be found for reporter {}. Available factories: {}.", new Object[]{factoryClassName, reporterName, reporterFactories.keySet()});
            return Optional.empty();
        }
        return TraceReporterSetup.loadViaFactory(reporterConfig, factory);
    }

    private static Optional<TraceReporter> loadViaFactory(Configuration reporterConfig, TraceReporterFactory factory) {
        MetricConfig metricConfig = new MetricConfig();
        reporterConfig.addAllToProperties((Properties)metricConfig);
        return Optional.of(factory.createTraceReporter((Properties)metricConfig));
    }
}

