/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddressResolutionTest
extends TestLogger {
    private static final RpcSystem RPC_SYSTEM = RpcSystem.load();
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String NON_EXISTING_HOSTNAME = "foo.bar.com.invalid";
    private static final int PORT = 17234;

    @BeforeClass
    public static void check() {
        AddressResolutionTest.checkPreconditions();
    }

    private static void checkPreconditions() {
        boolean throwsException;
        try {
            InetAddress.getByName(NON_EXISTING_HOSTNAME);
            throwsException = false;
        }
        catch (UnknownHostException e) {
            throwsException = true;
        }
        Assume.assumeTrue((boolean)throwsException);
    }

    @Test
    public void testNoAddressResolution() throws UnknownHostException {
        RPC_SYSTEM.getRpcUrl(NON_EXISTING_HOSTNAME, 17234, ENDPOINT_NAME, AddressResolution.NO_ADDRESS_RESOLUTION, new Configuration());
    }

    @Test
    public void testTryAddressResolution() {
        try {
            RPC_SYSTEM.getRpcUrl(NON_EXISTING_HOSTNAME, 17234, ENDPOINT_NAME, AddressResolution.TRY_ADDRESS_RESOLUTION, new Configuration());
            Assert.fail((String)"This should fail with an UnknownHostException");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

