/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResultTest;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLogicalVertexTest
extends TestLogger {
    private JobVertex jobVertex;
    private DefaultLogicalVertex logicalVertex;
    private Map<IntermediateDataSetID, IntermediateDataSet> resultMap;
    private Set<IntermediateDataSet> consumedResults;
    private Set<IntermediateDataSet> producedResults;

    @Before
    public void setUp() throws Exception {
        this.buildVerticesAndResults();
        this.logicalVertex = new DefaultLogicalVertex(this.jobVertex, rid -> new DefaultLogicalResult(this.resultMap.get(rid), vid -> null));
    }

    @Test
    public void testConstructor() {
        DefaultLogicalVertexTest.assertVertexInfoEquals(this.jobVertex, this.logicalVertex);
    }

    @Test
    public void testGetConsumedResults() {
        DefaultLogicalResultTest.assertResultsEquals(this.consumedResults, this.logicalVertex.getConsumedResults());
    }

    @Test
    public void testGetProducedResults() {
        DefaultLogicalResultTest.assertResultsEquals(this.producedResults, this.logicalVertex.getProducedResults());
    }

    private void buildVerticesAndResults() {
        this.resultMap = new HashMap<IntermediateDataSetID, IntermediateDataSet>();
        this.producedResults = new HashSet<IntermediateDataSet>();
        this.consumedResults = new HashSet<IntermediateDataSet>();
        int parallelism = 3;
        this.jobVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        for (int i = 0; i < 5; ++i) {
            IntermediateDataSet producedDataSet = this.jobVertex.createAndAddResultDataSet(ResultPartitionType.BLOCKING);
            this.producedResults.add(producedDataSet);
            this.resultMap.put(producedDataSet.getId(), producedDataSet);
        }
        JobVertex upStreamJobVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        for (int i = 0; i < 5; ++i) {
            IntermediateDataSet consumedDataSet = upStreamJobVertex.createAndAddResultDataSet(ResultPartitionType.PIPELINED);
            this.jobVertex.connectDataSetAsInput(consumedDataSet, DistributionPattern.ALL_TO_ALL);
            this.consumedResults.add(consumedDataSet);
            this.resultMap.put(consumedDataSet.getId(), consumedDataSet);
        }
    }

    static void assertVerticesEquals(Iterable<JobVertex> jobVertices, Iterable<DefaultLogicalVertex> logicalVertices) {
        Map logicalVertextMap = IterableUtils.toStream(logicalVertices).collect(Collectors.toMap(DefaultLogicalVertex::getId, Function.identity()));
        for (JobVertex jobVertex : jobVertices) {
            DefaultLogicalVertex logicalVertex = (DefaultLogicalVertex)logicalVertextMap.remove(jobVertex.getID());
            Assert.assertNotNull((Object)logicalVertex);
            DefaultLogicalVertexTest.assertVertexInfoEquals(jobVertex, logicalVertex);
        }
        Assert.assertEquals((long)0L, (long)logicalVertextMap.size());
    }

    static void assertVertexInfoEquals(JobVertex jobVertex, DefaultLogicalVertex logicalVertex) {
        Assert.assertEquals((Object)jobVertex.getID(), (Object)logicalVertex.getId());
    }
}

