/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.client.DuplicateJobSubmissionException;
import org.apache.flink.runtime.client.JobSubmissionException;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.SessionDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.TestingDispatcherGatewayService;
import org.apache.flink.runtime.dispatcher.runner.TestingDispatcherServiceFactory;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testutils.TestingJobGraphStore;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;
import org.apache.flink.util.function.TriFunction;
import org.apache.flink.util.function.TriFunctionWithException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SessionDispatcherLeaderProcessTest
extends TestLogger {
    private static final JobGraph JOB_GRAPH = JobGraphTestUtils.emptyJobGraph();
    private static ExecutorService ioExecutor;
    private final UUID leaderSessionId = UUID.randomUUID();
    private TestingFatalErrorHandler fatalErrorHandler;
    private JobGraphStore jobGraphStore;
    private TestingDispatcherServiceFactory dispatcherServiceFactory;

    @BeforeClass
    public static void setupClass() {
        ioExecutor = Executors.newSingleThreadExecutor();
    }

    @Before
    public void setup() {
        this.fatalErrorHandler = new TestingFatalErrorHandler();
        this.jobGraphStore = TestingJobGraphStore.newBuilder().build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().build();
    }

    @After
    public void teardown() throws Exception {
        if (this.fatalErrorHandler != null) {
            this.fatalErrorHandler.rethrowError();
            this.fatalErrorHandler = null;
        }
    }

    @AfterClass
    public static void teardownClass() {
        if (ioExecutor != null) {
            ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{ioExecutor});
        }
    }

    @Test
    public void start_afterClose_doesNotHaveAnEffect() throws Exception {
        SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();
        dispatcherLeaderProcess.close();
        dispatcherLeaderProcess.start();
        MatcherAssert.assertThat((Object)dispatcherLeaderProcess.getState(), (Matcher)CoreMatchers.is((Object)AbstractDispatcherLeaderProcess.State.STOPPED));
    }

    @Test
    public void start_triggersJobGraphRecoveryAndDispatcherServiceCreation() throws Exception {
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setInitialJobGraphs(Collections.singleton(JOB_GRAPH)).build();
        CompletableFuture recoveredJobGraphsFuture = new CompletableFuture();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(fencingToken, recoveredJobGraphs, jobGraphStore) -> {
            recoveredJobGraphsFuture.complete(recoveredJobGraphs);
            return TestingDispatcherGatewayService.newBuilder().build();
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            MatcherAssert.assertThat((Object)dispatcherLeaderProcess.getState(), (Matcher)CoreMatchers.is((Object)AbstractDispatcherLeaderProcess.State.RUNNING));
            Collection recoveredJobGraphs2 = (Collection)recoveredJobGraphsFuture.get();
            MatcherAssert.assertThat((Object)recoveredJobGraphs2, (Matcher)Matchers.containsInAnyOrder((Object[])new JobGraph[]{JOB_GRAPH}));
        }
    }

    @Test
    public void closeAsync_stopsJobGraphStoreAndDispatcher() throws Exception {
        CompletableFuture jobGraphStopFuture = new CompletableFuture();
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setStopRunnable((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> jobGraphStopFuture.complete(null))).build();
        CompletableFuture<Object> dispatcherServiceTerminationFuture = new CompletableFuture<Object>();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(ignoredA, ignoredB, ignoredC) -> TestingDispatcherGatewayService.newBuilder().setTerminationFuture(dispatcherServiceTerminationFuture).withManualTerminationFutureCompletion().build())).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            CompletableFuture terminationFuture = dispatcherLeaderProcess.closeAsync();
            MatcherAssert.assertThat((Object)jobGraphStopFuture.isDone(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)terminationFuture.isDone(), (Matcher)CoreMatchers.is((Object)false));
            dispatcherServiceTerminationFuture.complete(null);
            jobGraphStopFuture.get();
            terminationFuture.get();
        }
    }

    @Test
    public void unexpectedDispatcherServiceTerminationWhileRunning_callsFatalErrorHandler() {
        CompletableFuture terminationFuture = new CompletableFuture();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(ignoredA, ignoredB, ignoredC) -> TestingDispatcherGatewayService.newBuilder().setTerminationFuture(terminationFuture).build())).build();
        SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();
        dispatcherLeaderProcess.start();
        FlinkException expectedFailure = new FlinkException("Expected test failure.");
        terminationFuture.completeExceptionally((Throwable)expectedFailure);
        Throwable error = this.fatalErrorHandler.getErrorFuture().join();
        MatcherAssert.assertThat((Object)error, (Matcher)FlinkMatchers.containsCause((Throwable)expectedFailure));
        this.fatalErrorHandler.clearError();
    }

    @Test
    public void unexpectedDispatcherServiceTerminationWhileNotRunning_doesNotCallFatalErrorHandler() {
        CompletableFuture terminationFuture = new CompletableFuture();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(ignoredA, ignoredB, ignoredC) -> TestingDispatcherGatewayService.newBuilder().setTerminationFuture(terminationFuture).withManualTerminationFutureCompletion().build())).build();
        SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();
        dispatcherLeaderProcess.start();
        dispatcherLeaderProcess.closeAsync();
        FlinkException expectedFailure = new FlinkException("Expected test failure.");
        terminationFuture.completeExceptionally((Throwable)expectedFailure);
        MatcherAssert.assertThat(this.fatalErrorHandler.getErrorFuture(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(10L)));
    }

    @Test
    public void confirmLeaderSessionFuture_completesAfterDispatcherServiceHasBeenStarted() throws Exception {
        OneShotLatch createDispatcherServiceLatch = new OneShotLatch();
        String dispatcherAddress = "myAddress";
        TestingDispatcherGateway dispatcherGateway = ((TestingDispatcherGateway.Builder)new TestingDispatcherGateway.Builder().setAddress("myAddress")).build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)TriFunctionWithException.unchecked((ignoredA, ignoredB, ignoredC) -> {
            createDispatcherServiceLatch.await();
            return TestingDispatcherGatewayService.newBuilder().setDispatcherGateway(dispatcherGateway).build();
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            CompletableFuture confirmLeaderSessionFuture = dispatcherLeaderProcess.getLeaderAddressFuture();
            dispatcherLeaderProcess.start();
            MatcherAssert.assertThat((Object)confirmLeaderSessionFuture.isDone(), (Matcher)CoreMatchers.is((Object)false));
            createDispatcherServiceLatch.trigger();
            MatcherAssert.assertThat(confirmLeaderSessionFuture.get(), (Matcher)CoreMatchers.is((Object)"myAddress"));
        }
    }

    @Test
    public void closeAsync_duringJobRecovery_preventsDispatcherServiceCreation() throws Exception {
        OneShotLatch jobRecoveryStartedLatch = new OneShotLatch();
        OneShotLatch completeJobRecoveryLatch = new OneShotLatch();
        OneShotLatch createDispatcherServiceLatch = new OneShotLatch();
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setJobIdsFunction((FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception>)((FunctionWithException)storedJobs -> {
            jobRecoveryStartedLatch.trigger();
            completeJobRecoveryLatch.await();
            return storedJobs;
        })).build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(ignoredA, ignoredB, ignoredC) -> {
            createDispatcherServiceLatch.trigger();
            return TestingDispatcherGatewayService.newBuilder().build();
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            jobRecoveryStartedLatch.await();
            dispatcherLeaderProcess.closeAsync();
            completeJobRecoveryLatch.trigger();
            try {
                createDispatcherServiceLatch.await(10L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"No dispatcher service should be created after the process has been stopped.");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    @Test
    public void onRemovedJobGraph_terminatesRunningJob() throws Exception {
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setInitialJobGraphs(Collections.singleton(JOB_GRAPH)).build();
        CompletableFuture terminateJobFuture = new CompletableFuture();
        TestingDispatcherGatewayService testingDispatcherService = TestingDispatcherGatewayService.newBuilder().setOnRemovedJobGraphFunction(jobID -> {
            terminateJobFuture.complete(jobID);
            return FutureUtils.completedVoidFuture();
        }).build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(dispatcherId, jobGraphs, jobGraphWriter) -> testingDispatcherService)).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            this.jobGraphStore.removeJobGraph(JOB_GRAPH.getJobID());
            dispatcherLeaderProcess.onRemovedJobGraph(JOB_GRAPH.getJobID());
            MatcherAssert.assertThat(terminateJobFuture.get(), (Matcher)CoreMatchers.is((Object)JOB_GRAPH.getJobID()));
        }
    }

    @Test
    public void onRemovedJobGraph_failingRemovalCall_failsFatally() throws Exception {
        FlinkException testException = new FlinkException("Test exception");
        TestingDispatcherGatewayService testingDispatcherService = TestingDispatcherGatewayService.newBuilder().setOnRemovedJobGraphFunction(jobID -> FutureUtils.completedExceptionally((Throwable)testException)).build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(dispatcherId, jobGraphs, jobGraphWriter) -> testingDispatcherService)).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            dispatcherLeaderProcess.onRemovedJobGraph(JOB_GRAPH.getJobID());
            Throwable fatalError = this.fatalErrorHandler.getErrorFuture().join();
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)fatalError, cause -> cause.equals(testException)).isPresent());
            this.fatalErrorHandler.clearError();
        }
    }

    @Test
    public void onAddedJobGraph_submitsRecoveredJob() throws Exception {
        CompletableFuture submittedJobFuture = new CompletableFuture();
        TestingDispatcherGateway testingDispatcherGateway = new TestingDispatcherGateway.Builder().setSubmitFunction(submittedJob -> {
            submittedJobFuture.complete(submittedJob);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).build();
        this.dispatcherServiceFactory = this.createDispatcherServiceFactoryFor(testingDispatcherGateway);
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            this.jobGraphStore.putJobGraph(JOB_GRAPH);
            dispatcherLeaderProcess.onAddedJobGraph(JOB_GRAPH.getJobID());
            JobGraph submittedJobGraph = (JobGraph)submittedJobFuture.get();
            MatcherAssert.assertThat((Object)submittedJobGraph.getJobID(), (Matcher)CoreMatchers.is((Object)JOB_GRAPH.getJobID()));
        }
    }

    @Test
    public void onAddedJobGraph_ifNotRunning_isBeingIgnored() throws Exception {
        CompletableFuture recoveredJobFuture = new CompletableFuture();
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setRecoverJobGraphFunction((BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception>)((BiFunctionWithException)(jobId, jobGraphs) -> {
            recoveredJobFuture.complete(jobId);
            return (JobGraph)jobGraphs.get(jobId);
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            this.jobGraphStore.putJobGraph(JOB_GRAPH);
            dispatcherLeaderProcess.closeAsync();
            dispatcherLeaderProcess.onAddedJobGraph(JOB_GRAPH.getJobID());
            try {
                recoveredJobFuture.get(10L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"onAddedJobGraph should be ignored if the leader process is not running.");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    @Test
    public void onAddedJobGraph_failingRecovery_propagatesTheFailure() throws Exception {
        FlinkException expectedFailure = new FlinkException("Expected failure");
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setRecoverJobGraphFunction((BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception>)((BiFunctionWithException)(ignoredA, ignoredB) -> {
            throw expectedFailure;
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            this.jobGraphStore.putJobGraph(JOB_GRAPH);
            dispatcherLeaderProcess.onAddedJobGraph(JOB_GRAPH.getJobID());
            CompletableFuture<Throwable> errorFuture = this.fatalErrorHandler.getErrorFuture();
            Throwable throwable = errorFuture.get();
            MatcherAssert.assertThat((Object)ExceptionUtils.findThrowable((Throwable)throwable, expectedFailure::equals).isPresent(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)dispatcherLeaderProcess.getState(), (Matcher)CoreMatchers.is((Object)AbstractDispatcherLeaderProcess.State.STOPPED));
            this.fatalErrorHandler.clearError();
        }
    }

    @Test
    public void recoverJobs_withRecoveryFailure_failsFatally() throws Exception {
        FlinkException testException = new FlinkException("Test exception");
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setRecoverJobGraphFunction((BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception>)((BiFunctionWithException)(ignoredA, ignoredB) -> {
            throw testException;
        })).setInitialJobGraphs(Collections.singleton(JOB_GRAPH)).build();
        this.runJobRecoveryFailureTest(testException);
    }

    @Test
    public void recoverJobs_withJobIdRecoveryFailure_failsFatally() throws Exception {
        FlinkException testException = new FlinkException("Test exception");
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setJobIdsFunction((FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception>)((FunctionWithException)ignored -> {
            throw testException;
        })).build();
        this.runJobRecoveryFailureTest(testException);
    }

    private void runJobRecoveryFailureTest(FlinkException testException) throws Exception {
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            Throwable error = this.fatalErrorHandler.getErrorFuture().get();
            MatcherAssert.assertThat((Object)ExceptionUtils.findThrowableWithMessage((Throwable)error, (String)testException.getMessage()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
            this.fatalErrorHandler.clearError();
        }
    }

    @Test
    public void onAddedJobGraph_failingRecoveredJobSubmission_failsFatally() throws Exception {
        TestingDispatcherGateway dispatcherGateway = new TestingDispatcherGateway.Builder().setSubmitFunction(jobGraph -> FutureUtils.completedExceptionally((Throwable)new JobSubmissionException(jobGraph.getJobID(), "test exception"))).build();
        this.runOnAddedJobGraphTest(dispatcherGateway, (ThrowingConsumer<TestingFatalErrorHandler, Exception>)((ThrowingConsumer)this::verifyOnAddedJobGraphResultFailsFatally));
    }

    private void verifyOnAddedJobGraphResultFailsFatally(TestingFatalErrorHandler fatalErrorHandler) {
        Throwable actualCause = fatalErrorHandler.getErrorFuture().join();
        Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)actualCause, JobSubmissionException.class).isPresent());
        fatalErrorHandler.clearError();
    }

    @Test
    public void onAddedJobGraph_duplicateJobSubmissionDueToFalsePositive_willBeIgnored() throws Exception {
        TestingDispatcherGateway dispatcherGateway = new TestingDispatcherGateway.Builder().setSubmitFunction(jobGraph -> FutureUtils.completedExceptionally((Throwable)DuplicateJobSubmissionException.of((JobID)jobGraph.getJobID()))).build();
        this.runOnAddedJobGraphTest(dispatcherGateway, (ThrowingConsumer<TestingFatalErrorHandler, Exception>)((ThrowingConsumer)this::verifyOnAddedJobGraphResultDidNotFail));
    }

    private void runOnAddedJobGraphTest(TestingDispatcherGateway dispatcherGateway, ThrowingConsumer<TestingFatalErrorHandler, Exception> verificationLogic) throws Exception {
        this.jobGraphStore = TestingJobGraphStore.newBuilder().setInitialJobGraphs(Collections.singleton(JOB_GRAPH)).build();
        this.dispatcherServiceFactory = TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(dispatcherId, jobGraphs, jobGraphWriter) -> {
            MatcherAssert.assertThat((Object)jobGraphs, (Matcher)Matchers.containsInAnyOrder((Object[])new JobGraph[]{JOB_GRAPH}));
            return TestingDispatcherGatewayService.newBuilder().setDispatcherGateway(dispatcherGateway).build();
        })).build();
        try (SessionDispatcherLeaderProcess dispatcherLeaderProcess = this.createDispatcherLeaderProcess();){
            dispatcherLeaderProcess.start();
            dispatcherLeaderProcess.getDispatcherGateway().get();
            dispatcherLeaderProcess.onAddedJobGraph(JOB_GRAPH.getJobID());
            verificationLogic.accept((Object)this.fatalErrorHandler);
        }
    }

    private void verifyOnAddedJobGraphResultDidNotFail(TestingFatalErrorHandler fatalErrorHandler) throws Exception {
        try {
            fatalErrorHandler.getErrorFuture().get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected that duplicate job submissions due to false job recoveries are ignored.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private TestingDispatcherServiceFactory createDispatcherServiceFactoryFor(TestingDispatcherGateway testingDispatcherGateway) {
        return TestingDispatcherServiceFactory.newBuilder().setCreateFunction((TriFunction<DispatcherId, Collection<JobGraph>, JobGraphWriter, AbstractDispatcherLeaderProcess.DispatcherGatewayService>)((TriFunction)(ignoredA, ignoredB, ignoredC) -> TestingDispatcherGatewayService.newBuilder().setDispatcherGateway(testingDispatcherGateway).build())).build();
    }

    private SessionDispatcherLeaderProcess createDispatcherLeaderProcess() {
        return SessionDispatcherLeaderProcess.create((UUID)this.leaderSessionId, (AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory)this.dispatcherServiceFactory, (JobGraphStore)this.jobGraphStore, (Executor)ioExecutor, (FatalErrorHandler)this.fatalErrorHandler);
    }
}

