/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history.retaining;

import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.runtime.webmonitor.history.retaining.JobRetainedStrategy;

class QuantityJobRetainedStrategy
implements JobRetainedStrategy {
    private final int quantityThreshold;

    QuantityJobRetainedStrategy(int quantityThreshold) {
        if (quantityThreshold == 0 || quantityThreshold < -1) {
            throw new IllegalConfigurationException("Cannot set %s to 0 or less than -1", new Object[]{HistoryServerOptions.HISTORY_SERVER_RETAINED_JOBS.key()});
        }
        this.quantityThreshold = quantityThreshold;
    }

    @Override
    public boolean shouldRetain(FileStatus file, int fileOrderedIndex) {
        if (this.quantityThreshold == -1) {
            return true;
        }
        return fileOrderedIndex <= this.quantityThreshold;
    }
}

