/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenArrayDeserializer;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenMapDeserializer;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenRowDeserializer;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenSimpleDeserializer;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenDeserializeFactory {
    public static PbCodegenDeserializer getPbCodegenDes(Descriptors.FieldDescriptor fd, LogicalType type, PbFormatContext formatContext) throws PbCodegenException {
        if (type instanceof RowType) {
            return new PbCodegenRowDeserializer(fd.getMessageType(), (RowType)type, formatContext);
        }
        if (PbFormatUtils.isSimpleType(type)) {
            return new PbCodegenSimpleDeserializer(fd, type);
        }
        if (type instanceof ArrayType) {
            return new PbCodegenArrayDeserializer(fd, ((ArrayType)type).getElementType(), formatContext);
        }
        if (type instanceof MapType) {
            return new PbCodegenMapDeserializer(fd, (MapType)type, formatContext);
        }
        throw new PbCodegenException("Do not support flink type: " + String.valueOf(type));
    }

    public static PbCodegenDeserializer getPbCodegenTopRowDes(Descriptors.Descriptor descriptor, RowType rowType, PbFormatContext formatContext) {
        return new PbCodegenRowDeserializer(descriptor, rowType, formatContext);
    }
}

