/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.shim;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.vector.HiveOrcBatchWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.orc.OrcConf;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;

public class OrcShimV200
implements OrcShim<VectorizedRowBatch> {
    private static final long serialVersionUID = 1L;
    private transient Method hasNextMethod;
    private transient Method nextBatchMethod;

    protected Reader createReader(org.apache.hadoop.fs.Path path, Configuration conf) throws IOException {
        try {
            Class<?> orcFileClass = Class.forName("org.apache.hadoop.hive.ql.io.orc.OrcFile");
            Object readerOptions = MethodUtils.invokeStaticMethod(orcFileClass, (String)"readerOptions", (Object[])new Object[]{conf});
            Class<?> readerClass = Class.forName("org.apache.hadoop.hive.ql.io.orc.ReaderImpl");
            return (Reader)ConstructorUtils.invokeConstructor(readerClass, (Object[])new Object[]{path, readerOptions});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    protected RecordReader createRecordReader(Reader reader, Reader.Options options) throws IOException {
        try {
            return (RecordReader)MethodUtils.invokeExactMethod((Object)reader, (String)"rowsOptions", (Object[])new Object[]{options});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    protected Reader.Options readOrcConf(Reader.Options options, Configuration conf) {
        return options.useZeroCopy(OrcConf.USE_ZEROCOPY.getBoolean(conf)).skipCorruptRecords(OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf));
    }

    @Override
    public RecordReader createRecordReader(Configuration conf, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, Path path, long splitStart, long splitLength) throws IOException {
        org.apache.hadoop.fs.Path hPath = new org.apache.hadoop.fs.Path(path.toUri());
        Reader orcReader = this.createReader(hPath, conf);
        Tuple2<Long, Long> offsetAndLength = OrcShimV200.getOffsetAndLengthForSplit(splitStart, splitLength, orcReader.getStripes());
        Reader.Options options = this.readOrcConf(new Reader.Options().schema(schema).range(((Long)offsetAndLength.f0).longValue(), ((Long)offsetAndLength.f1).longValue()), conf);
        if (!conjunctPredicates.isEmpty()) {
            SearchArgument.Builder b = SearchArgumentFactory.newBuilder();
            b = b.startAnd();
            for (OrcFilters.Predicate predicate : conjunctPredicates) {
                predicate.add(b);
            }
            b = b.end();
            options.searchArgument(b.build(), new String[0]);
        }
        options.include(OrcShimV200.computeProjectionMask(schema, selectedFields));
        RecordReader orcRowsReader = this.createRecordReader(orcReader, options);
        schema.getId();
        return orcRowsReader;
    }

    public HiveOrcBatchWrapper createBatchWrapper(TypeDescription schema, int batchSize) {
        return new HiveOrcBatchWrapper(schema.createRowBatch(batchSize));
    }

    @Override
    public boolean nextBatch(RecordReader reader, VectorizedRowBatch rowBatch) throws IOException {
        try {
            boolean hasNext;
            if (this.hasNextMethod == null) {
                this.hasNextMethod = Class.forName("org.apache.hadoop.hive.ql.io.orc.RecordReader").getMethod("hasNext", new Class[0]);
                this.hasNextMethod.setAccessible(true);
            }
            if (this.nextBatchMethod == null) {
                this.nextBatchMethod = RecordReader.class.getMethod("nextBatch", VectorizedRowBatch.class);
                this.nextBatchMethod.setAccessible(true);
            }
            if (hasNext = ((Boolean)this.hasNextMethod.invoke((Object)reader, new Object[0])).booleanValue()) {
                this.nextBatchMethod.invoke((Object)reader, rowBatch);
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public static Tuple2<Long, Long> getOffsetAndLengthForSplit(long splitStart, long splitLength, List<StripeInformation> stripes) {
        long splitEnd = splitStart + splitLength;
        long readStart = Long.MAX_VALUE;
        long readEnd = Long.MIN_VALUE;
        for (StripeInformation s : stripes) {
            if (splitStart > s.getOffset() || s.getOffset() >= splitEnd) continue;
            readStart = Math.min(readStart, s.getOffset());
            readEnd = Math.max(readEnd, s.getOffset() + s.getLength());
        }
        if (readStart < Long.MAX_VALUE) {
            return Tuple2.of((Object)readStart, (Object)(readEnd - readStart));
        }
        return Tuple2.of((Object)0L, (Object)0L);
    }

    public static boolean[] computeProjectionMask(TypeDescription schema, int[] selectedFields) {
        boolean[] projectionMask = new boolean[schema.getMaximumId() + 1];
        for (int inIdx : selectedFields) {
            TypeDescription fieldSchema = (TypeDescription)schema.getChildren().get(inIdx);
            for (int i = fieldSchema.getId(); i <= fieldSchema.getMaximumId(); ++i) {
                projectionMask[i] = true;
            }
        }
        return projectionMask;
    }
}

