/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.IOException;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.columnar.ColumnarRowData;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.TypeDescription;

public class OrcColumnarRowSplitReader<BATCH>
extends OrcSplitReader<RowData, BATCH> {
    private final VectorizedColumnBatch columnarBatch;
    private final ColumnarRowData row;

    public OrcColumnarRowSplitReader(OrcShim<BATCH> shim, Configuration conf, TypeDescription schema, int[] selectedFields, ColumnBatchGenerator<BATCH> batchGenerator, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        super(shim, conf, schema, selectedFields, conjunctPredicates, batchSize, path, splitStart, splitLength);
        this.columnarBatch = batchGenerator.generate(this.rowBatchWrapper.getBatch());
        this.row = new ColumnarRowData(this.columnarBatch);
    }

    @Override
    protected int fillRows() {
        int size = this.rowBatchWrapper.size();
        this.columnarBatch.setNumRows(size);
        return size;
    }

    @Override
    public RowData nextRecord(RowData reuse) {
        this.row.setRowId(this.nextRow++);
        return this.row;
    }

    public static interface ColumnBatchGenerator<BATCH> {
        public VectorizedColumnBatch generate(BATCH var1);
    }
}

