/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.vector;

import org.apache.flink.orc.vector.AbstractOrcColumnVector;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.columnar.ColumnarMapData;
import org.apache.flink.table.data.columnar.vector.MapColumnVector;
import org.apache.flink.table.types.logical.MapType;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class OrcMapColumnVector
extends AbstractOrcColumnVector
implements MapColumnVector {
    private final org.apache.hadoop.hive.ql.exec.vector.MapColumnVector hiveVector;
    private final org.apache.flink.table.data.columnar.vector.ColumnVector keyFlinkVector;
    private final org.apache.flink.table.data.columnar.vector.ColumnVector valueFlinkVector;

    public OrcMapColumnVector(org.apache.hadoop.hive.ql.exec.vector.MapColumnVector hiveVector, MapType type) {
        super((ColumnVector)hiveVector);
        this.hiveVector = hiveVector;
        this.keyFlinkVector = OrcMapColumnVector.createFlinkVector(hiveVector.keys, type.getKeyType());
        this.valueFlinkVector = OrcMapColumnVector.createFlinkVector(hiveVector.values, type.getValueType());
    }

    public MapData getMap(int i) {
        long offset = this.hiveVector.offsets[i];
        long length = this.hiveVector.lengths[i];
        return new ColumnarMapData(this.keyFlinkVector, this.valueFlinkVector, (int)offset, (int)length);
    }
}

