/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class DataSinkNode
extends OptimizerNode {
    protected DagConnection input;

    public DataSinkNode(GenericDataSinkBase<?> sink) {
        super((Operator<?>)sink);
    }

    public DagConnection getInputConnection() {
        return this.input;
    }

    public OptimizerNode getPredecessorNode() {
        if (this.input != null) {
            return this.input.getSource();
        }
        return null;
    }

    public GenericDataSinkBase<?> getOperator() {
        return (GenericDataSinkBase)super.getOperator();
    }

    @Override
    public String getName() {
        return "Data Sink";
    }

    @Override
    public List<DagConnection> getIncomingConnections() {
        return Collections.singletonList(this.input);
    }

    @Override
    public List<DagConnection> getOutgoingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode, ExecutionMode defaultExchangeMode) {
        DagConnection conn;
        Operator children = this.getOperator().getInput();
        OptimizerNode pred = contractToNode.get(children);
        this.input = conn = new DagConnection(pred, this, defaultExchangeMode);
        pred.addOutgoingConnection(conn);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        this.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties iProps = new InterestingProperties();
        Ordering partitioning = this.getOperator().getPartitionOrdering();
        DataDistribution dataDist = this.getOperator().getDataDistribution();
        RequestedGlobalProperties partitioningProps = new RequestedGlobalProperties();
        if (partitioning != null) {
            if (dataDist != null) {
                partitioningProps.setRangePartitioned(partitioning, dataDist);
            } else {
                partitioningProps.setRangePartitioned(partitioning);
            }
            iProps.addGlobalProperties(partitioningProps);
        }
        iProps.addGlobalProperties(partitioningProps);
        Ordering localOrder = this.getOperator().getLocalOrder();
        RequestedLocalProperties orderProps = new RequestedLocalProperties();
        if (localOrder != null) {
            orderProps.setOrdering(localOrder);
        }
        iProps.addLocalProperties(orderProps);
        this.input.setInterestingProperties(iProps);
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getPredecessorNode().closedBranchingNodes);
        this.openBranches = this.getPredecessorNode().getBranchesForParent(this.input);
    }

    @Override
    protected List<OptimizerNode.UnclosedBranchDescriptor> getBranchesForParent(DagConnection parent) {
        return this.openBranches;
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        List<PlanNode> subPlans = this.getPredecessorNode().getAlternativePlans(estimator);
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        int parallelism = this.getParallelism();
        int inDop = this.getPredecessorNode().getParallelism();
        ExecutionMode executionMode = this.input.getDataExchangeMode();
        boolean dopChange = parallelism != inDop;
        boolean breakPipeline = this.input.isBreakingPipeline();
        InterestingProperties ips = this.input.getInterestingProperties();
        for (PlanNode p : subPlans) {
            for (RequestedGlobalProperties gp : ips.getGlobalProperties()) {
                for (RequestedLocalProperties lp : ips.getLocalProperties()) {
                    Channel c = new Channel(p);
                    gp.parameterizeChannel(c, dopChange, executionMode, breakPipeline);
                    lp.parameterizeChannel(c);
                    c.setRequiredLocalProps(lp);
                    c.setRequiredGlobalProps(gp);
                    outputPlans.add(new SinkPlanNode(this, "DataSink (" + this.getOperator().getName() + ")", c));
                }
            }
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SemanticProperties.EmptySemanticProperties();
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            if (this.getPredecessorNode() == null) {
                throw new CompilerException();
            }
            this.getPredecessorNode().accept(visitor);
            visitor.postVisit((Visitable)this);
        }
    }
}

