/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import java.util.Arrays;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.util.Utils;
import org.apache.flink.runtime.operators.util.LocalStrategy;

public class RequestedLocalProperties
implements Cloneable {
    private Ordering ordering;
    private FieldSet groupedFields;

    public RequestedLocalProperties() {
    }

    public RequestedLocalProperties(Ordering ordering) {
        this.ordering = ordering;
    }

    public RequestedLocalProperties(FieldSet groupedFields) {
        this.groupedFields = groupedFields;
    }

    private RequestedLocalProperties(Ordering ordering, FieldSet groupedFields) {
        this.ordering = ordering;
        this.groupedFields = groupedFields;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }

    public FieldSet getGroupedFields() {
        return this.groupedFields;
    }

    public void setGroupedFields(FieldSet groupedFields) {
        this.groupedFields = groupedFields;
    }

    public boolean isTrivial() {
        return this.ordering == null && this.groupedFields == null;
    }

    public void reset() {
        this.ordering = null;
        this.groupedFields = null;
    }

    public RequestedLocalProperties filterBySemanticProperties(SemanticProperties props, int input) {
        if (props == null) {
            throw new NullPointerException("SemanticProperties may not be null.");
        }
        if (this.ordering != null) {
            Ordering newOrdering = new Ordering();
            for (int i = 0; i < this.ordering.getInvolvedIndexes().size(); ++i) {
                int targetField = this.ordering.getInvolvedIndexes().get(i);
                int sourceField = props.getForwardingSourceField(input, targetField);
                if (sourceField < 0) {
                    return null;
                }
                newOrdering.appendOrdering(Integer.valueOf(sourceField), this.ordering.getType(i), this.ordering.getOrder(i));
            }
            return new RequestedLocalProperties(newOrdering);
        }
        if (this.groupedFields != null) {
            FieldSet newGrouping = new FieldSet();
            for (Integer targetField : this.groupedFields) {
                int sourceField = props.getForwardingSourceField(input, targetField.intValue());
                if (sourceField >= 0) {
                    newGrouping = newGrouping.addField(Integer.valueOf(sourceField));
                    continue;
                }
                return null;
            }
            return new RequestedLocalProperties(newGrouping);
        }
        return null;
    }

    public boolean isMetBy(LocalProperties other) {
        if (this.ordering != null) {
            return other.getOrdering() != null && this.ordering.isMetBy(other.getOrdering());
        }
        if (this.groupedFields != null) {
            if (other.getGroupedFields() != null && other.getGroupedFields().isValidUnorderedPrefix(this.groupedFields)) {
                return true;
            }
            return other.areFieldsUnique(this.groupedFields);
        }
        return true;
    }

    public void parameterizeChannel(Channel channel) {
        LocalProperties current = channel.getLocalProperties();
        if (this.isMetBy(current)) {
            channel.setLocalStrategy(LocalStrategy.NONE);
        } else if (this.ordering != null) {
            channel.setLocalStrategy(LocalStrategy.SORT, this.ordering.getInvolvedIndexes(), this.ordering.getFieldSortDirections());
        } else if (this.groupedFields != null) {
            boolean[] dirs = new boolean[this.groupedFields.size()];
            Arrays.fill(dirs, true);
            channel.setLocalStrategy(LocalStrategy.SORT, Utils.createOrderedFromSet(this.groupedFields), dirs);
        } else {
            channel.setLocalStrategy(LocalStrategy.NONE);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        result = 31 * result + (this.groupedFields == null ? 0 : this.groupedFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequestedLocalProperties) {
            RequestedLocalProperties other = (RequestedLocalProperties)obj;
            return (this.ordering == other.ordering || this.ordering != null && this.ordering.equals((Object)other.ordering)) && (this.groupedFields == other.groupedFields || this.groupedFields != null && this.groupedFields.equals((Object)other.groupedFields));
        }
        return false;
    }

    public String toString() {
        return "Requested Local Properties [ordering=" + this.ordering + ", grouped=" + this.groupedFields + "]";
    }

    public RequestedLocalProperties clone() {
        return new RequestedLocalProperties(this.ordering, this.groupedFields);
    }
}

