/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.model.openai.AbstractOpenAIModelFunction;
import org.apache.flink.model.openai.OpenAIChatModelFunction;
import org.apache.flink.model.openai.OpenAIEmbeddingModelFunction;
import org.apache.flink.model.openai.OpenAIOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModelProviderFactory;
import org.apache.flink.table.functions.AsyncPredictFunction;
import org.apache.flink.table.ml.AsyncPredictRuntimeProvider;
import org.apache.flink.table.ml.ModelProvider;

public class OpenAIModelProviderFactory
implements ModelProviderFactory {
    public static final String IDENTIFIER = "openai";

    public ModelProvider createModelProvider(ModelProviderFactory.Context context) {
        AbstractOpenAIModelFunction function;
        FactoryUtil.ModelProviderFactoryHelper helper = FactoryUtil.createModelProviderFactoryHelper((ModelProviderFactory)this, (ModelProviderFactory.Context)context);
        helper.validate();
        String endpoint = (String)helper.getOptions().get(OpenAIOptions.ENDPOINT);
        endpoint = endpoint.replaceAll("/*$", "").toLowerCase();
        if (endpoint.endsWith("embeddings")) {
            function = new OpenAIEmbeddingModelFunction(context, helper.getOptions());
        } else if (endpoint.endsWith("chat/completions")) {
            function = new OpenAIChatModelFunction(context, helper.getOptions());
        } else {
            throw new UnsupportedOperationException("Unsupported endpoint: " + endpoint);
        }
        return new Provider(function);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(OpenAIOptions.ENDPOINT);
        set.add(OpenAIOptions.API_KEY);
        set.add(OpenAIOptions.MODEL);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(OpenAIOptions.MAX_CONTEXT_SIZE);
        set.add(OpenAIOptions.CONTEXT_OVERFLOW_ACTION);
        set.add(OpenAIOptions.ERROR_HANDLING_STRATEGY);
        set.add(OpenAIOptions.RETRY_NUM);
        set.add(OpenAIOptions.RETRY_FALLBACK_STRATEGY);
        set.add(OpenAIOptions.SYSTEM_PROMPT);
        set.add(OpenAIOptions.TEMPERATURE);
        set.add(OpenAIOptions.TOP_P);
        set.add(OpenAIOptions.STOP);
        set.add(OpenAIOptions.MAX_TOKENS);
        set.add(OpenAIOptions.PRESENCE_PENALTY);
        set.add(OpenAIOptions.N);
        set.add(OpenAIOptions.SEED);
        set.add(OpenAIOptions.RESPONSE_FORMAT);
        set.add(OpenAIOptions.DIMENSION);
        return set;
    }

    public static class Provider
    implements AsyncPredictRuntimeProvider {
        private final AsyncPredictFunction function;

        public Provider(AsyncPredictFunction function) {
            this.function = function;
        }

        public AsyncPredictFunction createAsyncPredictFunction(ModelProvider.Context context) {
            return this.function;
        }

        public ModelProvider copy() {
            return new Provider(this.function);
        }
    }
}

