/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import com.knuddels.jtokkit.EncodingFactory;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.GptBytePairEncodingParams;
import com.knuddels.jtokkit.api.ModelType;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractEncodingRegistry
implements EncodingRegistry {
    private final ConcurrentHashMap<String, Encoding> encodings = new ConcurrentHashMap();

    AbstractEncodingRegistry() {
    }

    @Override
    public Optional<Encoding> getEncoding(String encodingName) {
        return Optional.ofNullable(this.encodings.get(encodingName));
    }

    @Override
    public Encoding getEncoding(EncodingType encodingType) {
        return Objects.requireNonNull(this.encodings.get(encodingType.getName()), () -> "No encoding registered for encoding type " + encodingType.getName());
    }

    @Override
    public Optional<Encoding> getEncodingForModel(String modelName) {
        Optional<ModelType> modelType = ModelType.fromName(modelName);
        if (modelType.isPresent()) {
            return Optional.of(this.getEncodingForModel(modelType.get()));
        }
        if (modelName.startsWith(ModelType.GPT_4O.getName())) {
            return Optional.of(this.getEncodingForModel(ModelType.GPT_4O));
        }
        if (modelName.startsWith(ModelType.GPT_4_32K.getName())) {
            return Optional.of(this.getEncodingForModel(ModelType.GPT_4_32K));
        }
        if (modelName.startsWith(ModelType.GPT_4.getName())) {
            return Optional.of(this.getEncodingForModel(ModelType.GPT_4));
        }
        if (modelName.startsWith(ModelType.GPT_3_5_TURBO_16K.getName())) {
            return Optional.of(this.getEncodingForModel(ModelType.GPT_3_5_TURBO_16K));
        }
        if (modelName.startsWith(ModelType.GPT_3_5_TURBO.getName())) {
            return Optional.of(this.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        }
        return Optional.empty();
    }

    @Override
    public Encoding getEncodingForModel(ModelType modelType) {
        return Objects.requireNonNull(this.encodings.get(modelType.getEncodingType().getName()), () -> "No encoding registered for model type " + modelType.getName());
    }

    @Override
    public EncodingRegistry registerGptBytePairEncoding(GptBytePairEncodingParams parameters2) {
        return this.registerCustomEncoding(EncodingFactory.fromParameters(parameters2));
    }

    @Override
    public EncodingRegistry registerCustomEncoding(Encoding encoding) {
        String encodingName = encoding.getName();
        Encoding previousEncoding = this.encodings.putIfAbsent(encodingName, encoding);
        if (previousEncoding != null) {
            throw new IllegalStateException("Encoding " + encodingName + " already registered");
        }
        return this;
    }

    protected final void addEncoding(EncodingType encodingType) {
        switch (encodingType) {
            case R50K_BASE: {
                this.encodings.computeIfAbsent(encodingType.getName(), k -> EncodingFactory.r50kBase());
                break;
            }
            case P50K_BASE: {
                this.encodings.computeIfAbsent(encodingType.getName(), k -> EncodingFactory.p50kBase());
                break;
            }
            case P50K_EDIT: {
                this.encodings.computeIfAbsent(encodingType.getName(), k -> EncodingFactory.p50kEdit());
                break;
            }
            case CL100K_BASE: {
                this.encodings.computeIfAbsent(encodingType.getName(), k -> EncodingFactory.cl100kBase());
                break;
            }
            case O200K_BASE: {
                this.encodings.computeIfAbsent(encodingType.getName(), k -> EncodingFactory.o200kBase());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown encoding type " + encodingType.getName());
            }
        }
    }
}

