/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.RequestConfig;

public class RequestConfigFluent<A extends RequestConfigFluent<A>>
extends BaseFluent<A> {
    private String impersonateUsername;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private Integer watchReconnectInterval;
    private Integer watchReconnectLimit;
    private Integer uploadRequestTimeout;
    private Integer requestRetryBackoffLimit;
    private Integer requestRetryBackoffInterval;
    private Integer requestTimeout;
    private Long scaleTimeout;
    private Integer loggingInterval;

    public RequestConfigFluent() {
    }

    public RequestConfigFluent(RequestConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequestConfig instance) {
        RequestConfig requestConfig = instance = instance != null ? instance : new RequestConfig();
        if (instance != null) {
            this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
            this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
            this.withRequestTimeout(instance.getRequestTimeout());
            this.withScaleTimeout(instance.getScaleTimeout());
            this.withLoggingInterval(instance.getLoggingInterval());
            this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
            this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
            this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
            this.withImpersonateUsername(instance.getImpersonateUsername());
            this.withImpersonateGroups(instance.getImpersonateGroups());
            this.withImpersonateExtras(instance.getImpersonateExtras());
        }
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    public boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
            this._visitables.remove("impersonateGroups");
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    public <K, V> A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    public boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    public Integer getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public A withWatchReconnectInterval(Integer watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    public boolean hasWatchReconnectInterval() {
        return this.watchReconnectInterval != null;
    }

    public Integer getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public A withWatchReconnectLimit(Integer watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    public boolean hasWatchReconnectLimit() {
        return this.watchReconnectLimit != null;
    }

    public Integer getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public A withUploadRequestTimeout(Integer uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
        return (A)this;
    }

    public boolean hasUploadRequestTimeout() {
        return this.uploadRequestTimeout != null;
    }

    public Integer getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public A withRequestRetryBackoffLimit(Integer requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit != null;
    }

    public Integer getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public A withRequestRetryBackoffInterval(Integer requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval != null;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public A withRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    public boolean hasRequestTimeout() {
        return this.requestTimeout != null;
    }

    public Long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public A withScaleTimeout(Long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    public boolean hasScaleTimeout() {
        return this.scaleTimeout != null;
    }

    public Integer getLoggingInterval() {
        return this.loggingInterval;
    }

    public A withLoggingInterval(Integer loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    public boolean hasLoggingInterval() {
        return this.loggingInterval != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigFluent that = (RequestConfigFluent)o;
        if (!Objects.equals(this.impersonateUsername, that.impersonateUsername)) {
            return false;
        }
        if (!Objects.equals(this.impersonateGroups, that.impersonateGroups)) {
            return false;
        }
        if (!Objects.equals(this.impersonateExtras, that.impersonateExtras)) {
            return false;
        }
        if (!Objects.equals(this.watchReconnectInterval, that.watchReconnectInterval)) {
            return false;
        }
        if (!Objects.equals(this.watchReconnectLimit, that.watchReconnectLimit)) {
            return false;
        }
        if (!Objects.equals(this.uploadRequestTimeout, that.uploadRequestTimeout)) {
            return false;
        }
        if (!Objects.equals(this.requestRetryBackoffLimit, that.requestRetryBackoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.requestRetryBackoffInterval, that.requestRetryBackoffInterval)) {
            return false;
        }
        if (!Objects.equals(this.requestTimeout, that.requestTimeout)) {
            return false;
        }
        if (!Objects.equals(this.scaleTimeout, that.scaleTimeout)) {
            return false;
        }
        return Objects.equals(this.loggingInterval, that.loggingInterval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.impersonateUsername, this.impersonateGroups, this.impersonateExtras, this.watchReconnectInterval, this.watchReconnectLimit, this.uploadRequestTimeout, this.requestRetryBackoffLimit, this.requestRetryBackoffInterval, this.requestTimeout, this.scaleTimeout, this.loggingInterval, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.impersonateUsername != null) {
            sb.append("impersonateUsername:");
            sb.append(this.impersonateUsername + ",");
        }
        if (this.impersonateGroups != null && !this.impersonateGroups.isEmpty()) {
            sb.append("impersonateGroups:");
            sb.append(String.valueOf(this.impersonateGroups) + ",");
        }
        if (this.impersonateExtras != null && !this.impersonateExtras.isEmpty()) {
            sb.append("impersonateExtras:");
            sb.append(String.valueOf(this.impersonateExtras) + ",");
        }
        if (this.watchReconnectInterval != null) {
            sb.append("watchReconnectInterval:");
            sb.append(this.watchReconnectInterval + ",");
        }
        if (this.watchReconnectLimit != null) {
            sb.append("watchReconnectLimit:");
            sb.append(this.watchReconnectLimit + ",");
        }
        if (this.uploadRequestTimeout != null) {
            sb.append("uploadRequestTimeout:");
            sb.append(this.uploadRequestTimeout + ",");
        }
        if (this.requestRetryBackoffLimit != null) {
            sb.append("requestRetryBackoffLimit:");
            sb.append(this.requestRetryBackoffLimit + ",");
        }
        if (this.requestRetryBackoffInterval != null) {
            sb.append("requestRetryBackoffInterval:");
            sb.append(this.requestRetryBackoffInterval + ",");
        }
        if (this.requestTimeout != null) {
            sb.append("requestTimeout:");
            sb.append(this.requestTimeout + ",");
        }
        if (this.scaleTimeout != null) {
            sb.append("scaleTimeout:");
            sb.append(this.scaleTimeout + ",");
        }
        if (this.loggingInterval != null) {
            sb.append("loggingInterval:");
            sb.append(this.loggingInterval);
        }
        sb.append("}");
        return sb.toString();
    }
}

