/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentStatus;

public class DeploymentStatusFluent<A extends DeploymentStatusFluent<A>>
extends BaseFluent<A> {
    private Integer availableReplicas;
    private Integer collisionCount;
    private ArrayList<DeploymentConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Integer terminatingReplicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;
    private Map<String, Object> additionalProperties;

    public DeploymentStatusFluent() {
    }

    public DeploymentStatusFluent(DeploymentStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentStatus instance) {
        DeploymentStatus deploymentStatus = instance = instance != null ? instance : new DeploymentStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withTerminatingReplicas(instance.getTerminatingReplicas());
            this.withUnavailableReplicas(instance.getUnavailableReplicas());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    public boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    public boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    public A addToConditions(int index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(DeploymentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<DeploymentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(DeploymentCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<DeploymentCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DeploymentConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DeploymentConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeploymentCondition> buildConditions() {
        return this.conditions != null ? DeploymentStatusFluent.build(this.conditions) : null;
    }

    public DeploymentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public DeploymentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public DeploymentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<DeploymentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(DeploymentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(DeploymentCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, DeploymentCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    public boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Integer getTerminatingReplicas() {
        return this.terminatingReplicas;
    }

    public A withTerminatingReplicas(Integer terminatingReplicas) {
        this.terminatingReplicas = terminatingReplicas;
        return (A)this;
    }

    public boolean hasTerminatingReplicas() {
        return this.terminatingReplicas != null;
    }

    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public A withUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return (A)this;
    }

    public boolean hasUnavailableReplicas() {
        return this.unavailableReplicas != null;
    }

    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    public boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentStatusFluent that = (DeploymentStatusFluent)o;
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.collisionCount, that.collisionCount)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.terminatingReplicas, that.terminatingReplicas)) {
            return false;
        }
        if (!Objects.equals(this.unavailableReplicas, that.unavailableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.updatedReplicas, that.updatedReplicas)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.terminatingReplicas, this.unavailableReplicas, this.updatedReplicas, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.collisionCount != null) {
            sb.append("collisionCount:");
            sb.append(this.collisionCount + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.terminatingReplicas != null) {
            sb.append("terminatingReplicas:");
            sb.append(this.terminatingReplicas + ",");
        }
        if (this.unavailableReplicas != null) {
            sb.append("unavailableReplicas:");
            sb.append(this.unavailableReplicas + ",");
        }
        if (this.updatedReplicas != null) {
            sb.append("updatedReplicas:");
            sb.append(this.updatedReplicas + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends DeploymentConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        DeploymentConditionBuilder builder;
        int index;

        ConditionsNested(int index, DeploymentCondition item) {
            this.index = index;
            this.builder = new DeploymentConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

