/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceStatus;

public class NamespaceStatusFluent<A extends NamespaceStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NamespaceConditionBuilder> conditions = new ArrayList();
    private String phase;
    private Map<String, Object> additionalProperties;

    public NamespaceStatusFluent() {
    }

    public NamespaceStatusFluent(NamespaceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamespaceStatus instance) {
        NamespaceStatus namespaceStatus = instance = instance != null ? instance : new NamespaceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withPhase(instance.getPhase());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(NamespaceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(NamespaceCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<NamespaceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<NamespaceConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            NamespaceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamespaceCondition> buildConditions() {
        return this.conditions != null ? NamespaceStatusFluent.build(this.conditions) : null;
    }

    public NamespaceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public NamespaceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public NamespaceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public NamespaceCondition buildMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<NamespaceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(NamespaceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(NamespaceCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, NamespaceCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceStatusFluent that = (NamespaceStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.phase, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends NamespaceConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        NamespaceConditionBuilder builder;
        int index;

        ConditionsNested(int index, NamespaceCondition item) {
            this.index = index;
            this.builder = new NamespaceConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamespaceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

