/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServicePort;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.IngressList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ServiceToURLProvider;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.internal.URLFromServiceUtil;

public class URLFromIngressImpl
implements ServiceToURLProvider {
    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        IngressList ingresses;
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceName = service.getMetadata().getName();
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + portName + " for service " + service.getMetadata().getName());
        }
        if (client.supports(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Ingress.class)) {
            org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressList ingresses2 = (org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses2 != null && !ingresses2.getItems().isEmpty()) {
                return URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingresses2.getItems(), namespace, serviceName, port);
            }
        } else if (client.supports(Ingress.class) && (ingresses = (IngressList)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(namespace)).list()) != null && !ingresses.getItems().isEmpty()) {
            return URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingresses.getItems(), namespace, serviceName, port);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue();
    }
}

