/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPath;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Volume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeFluent;
import org.apache.flink.kubernetes.utils.Constants;
import org.apache.flink.shaded.guava33.com.google.common.io.Files;
import org.apache.flink.util.Preconditions;

public class FlinkConfMountDecorator
extends AbstractKubernetesStepDecorator {
    private final AbstractKubernetesParameters kubernetesComponentConf;

    public FlinkConfMountDecorator(AbstractKubernetesParameters kubernetesComponentConf) {
        this.kubernetesComponentConf = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesComponentConf);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Pod mountedPod = this.decoratePod(flinkPod.getPodWithoutMainContainer());
        Container mountedMainContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(flinkPod.getMainContainer()).addNewVolumeMount().withName("flink-config-volume")).withMountPath(this.kubernetesComponentConf.getFlinkConfDirInPod())).endVolumeMount()).build();
        return new FlinkPod.Builder(flinkPod).withPod(mountedPod).withMainContainer(mountedMainContainer).build();
    }

    private Pod decoratePod(Pod pod) {
        List<KeyToPath> keyToPaths = this.getLocalLogConfFiles().stream().map(file -> ((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(file.getName())).withPath(file.getName())).build()).collect(Collectors.toList());
        keyToPaths.add(((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(GlobalConfiguration.getFlinkConfFilename())).withPath(GlobalConfiguration.getFlinkConfFilename())).build());
        Volume flinkConfVolume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName("flink-config-volume")).withNewConfigMap().withName(FlinkConfMountDecorator.getFlinkConfConfigMapName(this.kubernetesComponentConf.getClusterId()))).withItems(keyToPaths)).endConfigMap()).build();
        return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().addNewVolumeLike(flinkConfVolume).endVolume()).endSpec()).build();
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        String clusterId = this.kubernetesComponentConf.getClusterId();
        HashMap<String, String> data = new HashMap<String, String>();
        List<File> localLogFiles = this.getLocalLogConfFiles();
        for (File file : localLogFiles) {
            data.put(file.getName(), Files.toString((File)file, (Charset)StandardCharsets.UTF_8));
        }
        List<String> confData = this.getClusterSideConfData(this.kubernetesComponentConf.getFlinkConfiguration());
        data.put(GlobalConfiguration.getFlinkConfFilename(), this.getFlinkConfData(confData));
        ConfigMap flinkConfConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withApiVersion("v1")).withNewMetadata().withName(FlinkConfMountDecorator.getFlinkConfConfigMapName(clusterId))).withLabels(this.kubernetesComponentConf.getCommonLabels())).endMetadata()).addToData(data)).build();
        return Collections.singletonList(flinkConfConfigMap);
    }

    private List<String> getClusterSideConfData(Configuration flinkConfig) {
        Configuration clusterSideConfig = flinkConfig.clone();
        clusterSideConfig.removeConfig(KubernetesConfigOptions.KUBE_CONFIG_FILE);
        clusterSideConfig.removeConfig(DeploymentOptionsInternal.CONF_DIR);
        clusterSideConfig.removeConfig(RestOptions.BIND_ADDRESS);
        clusterSideConfig.removeConfig(JobManagerOptions.BIND_HOST);
        clusterSideConfig.removeConfig(TaskManagerOptions.BIND_HOST);
        clusterSideConfig.removeConfig(TaskManagerOptions.HOST);
        return ConfigurationUtils.convertConfigToWritableLines((Configuration)clusterSideConfig, (boolean)false);
    }

    @VisibleForTesting
    String getFlinkConfData(List<String> confData) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PrintWriter out = new PrintWriter(sw);
            try {
                confData.forEach(out::println);
                String string = sw.toString();
                out.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private List<File> getLocalLogConfFiles() {
        String confDir = this.kubernetesComponentConf.getConfigDirectory();
        ArrayList<File> localLogConfFiles = new ArrayList<File>();
        for (String fileName : Constants.CONFIG_FILE_NAME_LIST) {
            File file = new File(confDir, fileName);
            if (!file.exists()) continue;
            localLogConfFiles.add(file);
        }
        return localLogConfFiles;
    }

    @VisibleForTesting
    public static String getFlinkConfConfigMapName(String clusterId) {
        return "flink-config-" + clusterId;
    }
}

