/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRef;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRefBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRefFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRule;

public class UDPRouteRuleFluent<A extends UDPRouteRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<BackendRefBuilder> backendRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public UDPRouteRuleFluent() {
    }

    public UDPRouteRuleFluent(UDPRouteRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(UDPRouteRule instance) {
        UDPRouteRule uDPRouteRule = instance = instance != null ? instance : new UDPRouteRule();
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get("backendRefs").add(index, builder);
            this.backendRefs.add(index, builder);
        }
        return (A)this;
    }

    public A setToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get("backendRefs").set(index, builder);
            this.backendRefs.set(index, builder);
        }
        return (A)this;
    }

    public A addToBackendRefs(BackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    public A addAllToBackendRefs(Collection<BackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    public A removeFromBackendRefs(BackendRef ... items) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get("backendRefs").remove(builder);
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromBackendRefs(Collection<BackendRef> items) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get("backendRefs").remove(builder);
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBackendRefs(Predicate<BackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        Iterator<BackendRefBuilder> each = this.backendRefs.iterator();
        Object visitables = this._visitables.get("backendRefs");
        while (each.hasNext()) {
            BackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BackendRef> buildBackendRefs() {
        return this.backendRefs != null ? UDPRouteRuleFluent.build(this.backendRefs) : null;
    }

    public BackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    public BackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    public BackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    public BackendRef buildMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBackendRefs(List<BackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get("backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)this;
    }

    public A withBackendRefs(BackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove("backendRefs");
        }
        if (backendRefs != null) {
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)this;
    }

    public boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    public BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNested(-1, null);
    }

    public BackendRefsNested<A> addNewBackendRefLike(BackendRef item) {
        return new BackendRefsNested(-1, item);
    }

    public BackendRefsNested<A> setNewBackendRefLike(int index, BackendRef item) {
        return new BackendRefsNested(index, item);
    }

    public BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    public BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching backendRefs. No match found.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UDPRouteRuleFluent that = (UDPRouteRuleFluent)o;
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backendRefs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null && !this.backendRefs.isEmpty()) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BackendRefsNested<N>
    extends BackendRefFluent<BackendRefsNested<N>>
    implements Nested<N> {
        BackendRefBuilder builder;
        int index;

        BackendRefsNested(int index, BackendRef item) {
            this.index = index;
            this.builder = new BackendRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)UDPRouteRuleFluent.this.setToBackendRefs(this.index, this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

