/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesVersionFactory;

public class KubernetesVersionPriority {
    private KubernetesVersionPriority() {
    }

    public static String highestPriority(List<String> versions) {
        List<KubernetesVersionFactory.Version> byPriority = KubernetesVersionPriority.getByPriority(versions);
        if (byPriority.isEmpty()) {
            return null;
        }
        return byPriority.get(0).getFull();
    }

    private static List<KubernetesVersionFactory.Version> getByPriority(List<String> versions) {
        if (versions == null || versions.isEmpty()) {
            return Collections.emptyList();
        }
        return versions.stream().map(KubernetesVersionFactory::create).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }
}

