/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TypedObjectReferenceFluent;

public class PersistentVolumeClaimSpecFluent<A extends PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private TypedLocalObjectReferenceBuilder dataSource;
    private TypedObjectReferenceBuilder dataSourceRef;
    private ResourceRequirementsBuilder resources;
    private LabelSelectorBuilder selector;
    private String storageClassName;
    private String volumeMode;
    private String volumeName;
    private Map<String, Object> additionalProperties;

    public PersistentVolumeClaimSpecFluent() {
    }

    public PersistentVolumeClaimSpecFluent(PersistentVolumeClaimSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PersistentVolumeClaimSpec instance) {
        PersistentVolumeClaimSpec persistentVolumeClaimSpec = instance = instance != null ? instance : new PersistentVolumeClaimSpec();
        if (instance != null) {
            this.withAccessModes(instance.getAccessModes());
            this.withDataSource(instance.getDataSource());
            this.withDataSourceRef(instance.getDataSourceRef());
            this.withResources(instance.getResources());
            this.withSelector(instance.getSelector());
            this.withStorageClassName(instance.getStorageClassName());
            this.withVolumeMode(instance.getVolumeMode());
            this.withVolumeName(instance.getVolumeName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    public A setToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)this;
    }

    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    public A removeFromAccessModes(String ... items) {
        if (this.accessModes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAccessModes(List<String> accessModes) {
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)this;
    }

    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
            this._visitables.remove("accessModes");
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    public boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    public TypedLocalObjectReference buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    public A withDataSource(TypedLocalObjectReference dataSource) {
        this._visitables.remove("dataSource");
        if (dataSource != null) {
            this.dataSource = new TypedLocalObjectReferenceBuilder(dataSource);
            this._visitables.get("dataSource").add(this.dataSource);
        } else {
            this.dataSource = null;
            this._visitables.get("dataSource").remove(this.dataSource);
        }
        return (A)this;
    }

    public boolean hasDataSource() {
        return this.dataSource != null;
    }

    public A withNewDataSource(String apiGroup, String kind, String name) {
        return this.withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public DataSourceNested<A> withNewDataSource() {
        return new DataSourceNested(null);
    }

    public DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item) {
        return new DataSourceNested(item);
    }

    public DataSourceNested<A> editDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(null));
    }

    public DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(new TypedLocalObjectReferenceBuilder().build()));
    }

    public DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item) {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(item));
    }

    public TypedObjectReference buildDataSourceRef() {
        return this.dataSourceRef != null ? this.dataSourceRef.build() : null;
    }

    public A withDataSourceRef(TypedObjectReference dataSourceRef) {
        this._visitables.remove("dataSourceRef");
        if (dataSourceRef != null) {
            this.dataSourceRef = new TypedObjectReferenceBuilder(dataSourceRef);
            this._visitables.get("dataSourceRef").add(this.dataSourceRef);
        } else {
            this.dataSourceRef = null;
            this._visitables.get("dataSourceRef").remove(this.dataSourceRef);
        }
        return (A)this;
    }

    public boolean hasDataSourceRef() {
        return this.dataSourceRef != null;
    }

    public A withNewDataSourceRef(String apiGroup, String kind, String name, String namespace) {
        return this.withDataSourceRef(new TypedObjectReference(apiGroup, kind, name, namespace));
    }

    public DataSourceRefNested<A> withNewDataSourceRef() {
        return new DataSourceRefNested(null);
    }

    public DataSourceRefNested<A> withNewDataSourceRefLike(TypedObjectReference item) {
        return new DataSourceRefNested(item);
    }

    public DataSourceRefNested<A> editDataSourceRef() {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(null));
    }

    public DataSourceRefNested<A> editOrNewDataSourceRef() {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(new TypedObjectReferenceBuilder().build()));
    }

    public DataSourceRefNested<A> editOrNewDataSourceRefLike(TypedObjectReference item) {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(item));
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    public boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public A withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return (A)this;
    }

    public boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimSpecFluent that = (PersistentVolumeClaimSpecFluent)o;
        if (!Objects.equals(this.accessModes, that.accessModes)) {
            return false;
        }
        if (!Objects.equals(this.dataSource, that.dataSource)) {
            return false;
        }
        if (!Objects.equals(this.dataSourceRef, that.dataSourceRef)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.storageClassName, that.storageClassName)) {
            return false;
        }
        if (!Objects.equals(this.volumeMode, that.volumeMode)) {
            return false;
        }
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessModes != null && !this.accessModes.isEmpty()) {
            sb.append("accessModes:");
            sb.append(this.accessModes + ",");
        }
        if (this.dataSource != null) {
            sb.append("dataSource:");
            sb.append(this.dataSource + ",");
        }
        if (this.dataSourceRef != null) {
            sb.append("dataSourceRef:");
            sb.append(this.dataSourceRef + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName + ",");
        }
        if (this.volumeMode != null) {
            sb.append("volumeMode:");
            sb.append(this.volumeMode + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class DataSourceRefNested<N>
    extends TypedObjectReferenceFluent<DataSourceRefNested<N>>
    implements Nested<N> {
        TypedObjectReferenceBuilder builder;

        DataSourceRefNested(TypedObjectReference item) {
            this.builder = new TypedObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluent.this.withDataSourceRef(this.builder.build());
        }

        public N endDataSourceRef() {
            return this.and();
        }
    }

    public class DataSourceNested<N>
    extends TypedLocalObjectReferenceFluent<DataSourceNested<N>>
    implements Nested<N> {
        TypedLocalObjectReferenceBuilder builder;

        DataSourceNested(TypedLocalObjectReference item) {
            this.builder = new TypedLocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluent.this.withDataSource(this.builder.build());
        }

        public N endDataSource() {
            return this.and();
        }
    }
}

