/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;

@Internal
public class StringSummaryAggregator
implements Aggregator<String, StringColumnSummary> {
    private long nonNullCount = 0L;
    private long nullCount = 0L;
    private long emptyCount = 0L;
    private int minStringLength = Integer.MAX_VALUE;
    private int maxStringLength = -1;
    private CompensatedSum meanLength = CompensatedSum.ZERO;

    @Override
    public void aggregate(String value) {
        if (value == null) {
            ++this.nullCount;
        } else {
            ++this.nonNullCount;
            if (value.isEmpty()) {
                ++this.emptyCount;
            }
            int length = value.length();
            this.minStringLength = Math.min(this.minStringLength, length);
            this.maxStringLength = Math.max(this.maxStringLength, length);
            double delta = (double)length - this.meanLength.value();
            this.meanLength = this.meanLength.add(delta / (double)this.nonNullCount);
        }
    }

    @Override
    public void combine(Aggregator<String, StringColumnSummary> otherSameType) {
        StringSummaryAggregator other = (StringSummaryAggregator)otherSameType;
        this.nullCount += other.nullCount;
        this.minStringLength = Math.min(this.minStringLength, other.minStringLength);
        this.maxStringLength = Math.max(this.maxStringLength, other.maxStringLength);
        if (this.nonNullCount == 0L) {
            this.nonNullCount = other.nonNullCount;
            this.emptyCount = other.emptyCount;
            this.meanLength = other.meanLength;
        } else if (other.nonNullCount != 0L) {
            long combinedCount = this.nonNullCount + other.nonNullCount;
            this.emptyCount += other.emptyCount;
            double deltaMean = other.meanLength.value() - this.meanLength.value();
            this.meanLength = this.meanLength.add(deltaMean * (double)other.nonNullCount / (double)combinedCount);
            this.nonNullCount = combinedCount;
        }
    }

    @Override
    public StringColumnSummary result() {
        return new StringColumnSummary(this.nonNullCount, this.nullCount, this.emptyCount, this.nonNullCount == 0L ? null : Integer.valueOf(this.minStringLength), this.nonNullCount == 0L ? null : Integer.valueOf(this.maxStringLength), this.nonNullCount == 0L ? null : Double.valueOf(this.meanLength.value()));
    }
}

