/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.This0AccessFinder;
import org.apache.flink.shaded.org.objectweb.asm.ClassReader;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClosureCleaner {
    private static Logger LOG = LoggerFactory.getLogger(ClosureCleaner.class);

    public static void clean(Object func, boolean checkSerializable) {
        if (func == null) {
            return;
        }
        Class<?> cls = func.getClass();
        boolean closureAccessed = false;
        for (Field f : cls.getDeclaredFields()) {
            if (!f.getName().startsWith("this$")) continue;
            closureAccessed |= ClosureCleaner.cleanThis0(func, cls, f.getName());
        }
        if (checkSerializable) {
            try {
                InstantiationUtil.serializeObject((Object)func);
            }
            catch (Exception e) {
                String functionType = ClosureCleaner.getSuperClassOrInterfaceName(func.getClass());
                String msg = functionType == null ? func + " is not serializable." : "The implementation of the " + functionType + " is not serializable.";
                msg = closureAccessed ? msg + " The implementation accesses fields of its enclosing class, which is a common reason for non-serializability. A common solution is to make the function a proper (non-inner) class, ora static inner class." : msg + " The object probably contains or references non serializable fields.";
                throw new InvalidProgramException(msg, (Throwable)e);
            }
        }
    }

    public static void ensureSerializable(Object obj) {
        try {
            InstantiationUtil.serializeObject((Object)obj);
        }
        catch (Exception e) {
            throw new InvalidProgramException("Object " + obj + " is not serializable", (Throwable)e);
        }
    }

    private static boolean cleanThis0(Object func, Class<?> cls, String this0Name) {
        This0AccessFinder this0Finder = new This0AccessFinder(this0Name);
        ClosureCleaner.getClassReader(cls).accept(this0Finder, 0);
        boolean accessesClosure = this0Finder.isThis0Accessed();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this0Name + " is accessed: " + accessesClosure);
        }
        if (!accessesClosure) {
            Field this0;
            try {
                this0 = func.getClass().getDeclaredField(this0Name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Could not set " + this0Name + ": " + e);
            }
            try {
                this0.setAccessible(true);
                this0.set(func, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set " + this0Name + " to null. " + e.getMessage(), e);
            }
        }
        return accessesClosure;
    }

    private static ClassReader getClassReader(Class<?> cls) {
        String className = cls.getName().replaceFirst("^.*\\.", "") + ".class";
        try {
            return new ClassReader(cls.getResourceAsStream(className));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create ClassReader: " + e.getMessage(), e);
        }
    }

    private static String getSuperClassOrInterfaceName(Class<?> cls) {
        Class<?> superclass = cls.getSuperclass();
        if (superclass.getName().startsWith("org.apache.flink")) {
            return superclass.getSimpleName();
        }
        for (Class<?> inFace : cls.getInterfaces()) {
            if (!inFace.getName().startsWith("org.apache.flink")) continue;
            return inFace.getSimpleName();
        }
        return null;
    }
}

