/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.Operator;

@Public
public abstract class TwoInputOperator<IN1, IN2, OUT, O extends TwoInputOperator<IN1, IN2, OUT, O>>
extends Operator<OUT, O> {
    private final DataSet<IN1> input1;
    private final DataSet<IN2> input2;

    protected TwoInputOperator(DataSet<IN1> input1, DataSet<IN2> input2, TypeInformation<OUT> resultType) {
        super(input1.getExecutionEnvironment(), resultType);
        DataSet.checkSameExecutionContext(input1, input2);
        this.input1 = input1;
        this.input2 = input2;
    }

    public DataSet<IN1> getInput1() {
        return this.input1;
    }

    public DataSet<IN2> getInput2() {
        return this.input2;
    }

    public TypeInformation<IN1> getInput1Type() {
        return this.input1.getType();
    }

    public TypeInformation<IN2> getInput2Type() {
        return this.input2.getType();
    }

    protected abstract org.apache.flink.api.common.operators.Operator<OUT> translateToDataFlow(org.apache.flink.api.common.operators.Operator<IN1> var1, org.apache.flink.api.common.operators.Operator<IN2> var2);
}

