/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public abstract class TupleSerializerBase<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    protected final Class<T> tupleClass;
    protected TypeSerializer<Object>[] fieldSerializers;
    protected final int arity;

    public TupleSerializerBase(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        this.tupleClass = tupleClass;
        this.fieldSerializers = fieldSerializers;
        this.arity = fieldSerializers.length;
    }

    public Class<T> getTupleClass() {
        return this.tupleClass;
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public int getArity() {
        return this.arity;
    }

    public abstract T createInstance(Object[] var1);

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            this.fieldSerializers[i].copy(source, target);
        }
    }

    public int hashCode() {
        int hashCode = this.arity * 47;
        for (TypeSerializer<Object> ser : this.fieldSerializers) {
            hashCode = hashCode << 7 | hashCode >>> -7;
            hashCode += ser.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TupleSerializerBase) {
            TupleSerializerBase otherTS = (TupleSerializerBase)((Object)obj);
            return otherTS.tupleClass == this.tupleClass && Arrays.deepEquals(this.fieldSerializers, otherTS.fieldSerializers);
        }
        return false;
    }
}

