/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.PrintStream;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;

public class PrintingOutputFormat<T>
implements OutputFormat<T> {
    private static final long serialVersionUID = 1L;
    private static final boolean STD_OUT = false;
    private static final boolean STD_ERR = true;
    private String sinkIdentifier;
    private boolean target;
    private transient PrintStream stream;
    private transient String prefix;

    public PrintingOutputFormat() {
    }

    public PrintingOutputFormat(boolean stdErr) {
        this.target = stdErr;
    }

    public PrintingOutputFormat(String sinkIdentifier, boolean stdErr) {
        this(stdErr);
        this.sinkIdentifier = sinkIdentifier;
    }

    public void setTargetToStandardOut() {
        this.target = false;
    }

    public void setTargetToStandardErr() {
        this.target = true;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) {
        PrintStream printStream = this.stream = !this.target ? System.out : System.err;
        if (this.sinkIdentifier != null) {
            this.prefix = this.sinkIdentifier;
            if (numTasks > 1) {
                this.prefix = this.prefix + ":" + (taskNumber + 1);
            }
            this.prefix = this.prefix + "> ";
        } else {
            this.prefix = numTasks > 1 ? taskNumber + 1 + "> " : "";
        }
    }

    public void writeRecord(T record) {
        this.stream.println(this.prefix + record.toString());
    }

    public void close() {
        this.stream = null;
        this.prefix = null;
        this.sinkIdentifier = null;
    }

    public String toString() {
        return "Print to " + (!this.target ? "System.out" : "System.err");
    }
}

