/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

public class ExternalProcessInputSplit
extends GenericInputSplit {
    private static final long serialVersionUID = 1L;
    private String extProcessCommand;

    public ExternalProcessInputSplit() {
    }

    public ExternalProcessInputSplit(int splitNumber, int numSplits, String extProcCommand) {
        super(splitNumber, numSplits);
        this.extProcessCommand = extProcCommand;
    }

    public String getExternalProcessCommand() {
        return this.extProcessCommand;
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.extProcessCommand = StringUtils.readNullableString((DataInputView)in);
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        StringUtils.writeNullableString((String)this.extProcessCommand, (DataOutputView)out);
    }
}

