/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;

public class TypeInfoParser {
    private static final String TUPLE_PACKAGE = "org.apache.flink.api.java.tuple";
    private static final String VALUE_PACKAGE = "org.apache.flink.types";
    private static final String WRITABLE_PACKAGE = "org.apache.hadoop.io";
    private static final Pattern tuplePattern = Pattern.compile("^((" + "org.apache.flink.api.java.tuple".replaceAll("\\.", "\\\\.") + "\\.)?Tuple[0-9]+)<");
    private static final Pattern writablePattern = Pattern.compile("^((" + "org.apache.hadoop.io".replaceAll("\\.", "\\\\.") + "\\.)?Writable)<([^\\s,>]*)(,|>|$|\\[)");
    private static final Pattern enumPattern = Pattern.compile("^((java\\.lang\\.)?Enum)<([^\\s,>]*)(,|>|$|\\[)");
    private static final Pattern basicTypePattern = Pattern.compile("^((java\\.lang\\.)?(String|Integer|Byte|Short|Character|Double|Float|Long|Boolean|Void))(,|>|$|\\[)");
    private static final Pattern basicTypeDatePattern = Pattern.compile("^((java\\.util\\.)?Date)(,|>|$|\\[)");
    private static final Pattern primitiveTypePattern = Pattern.compile("^(int|byte|short|char|double|float|long|boolean|void)(,|>|$|\\[)");
    private static final Pattern valueTypePattern = Pattern.compile("^((" + "org.apache.flink.types".replaceAll("\\.", "\\\\.") + "\\.)?(String|Int|Byte|Short|Char|Double|Float|Long|Boolean|List|Map|Null))Value(,|>|$|\\[)");
    private static final Pattern pojoGenericObjectPattern = Pattern.compile("^([^\\s,<>\\[]+)(<)?");
    private static final Pattern fieldPattern = Pattern.compile("^([^\\s,<>\\[]+)=");

    public static <X> TypeInformation<X> parse(String infoString) {
        try {
            if (infoString == null) {
                throw new IllegalArgumentException("String is null.");
            }
            String clearedString = infoString.replaceAll("\\s", "");
            if (clearedString.length() == 0) {
                throw new IllegalArgumentException("String must not be empty.");
            }
            StringBuilder sb = new StringBuilder(clearedString);
            TypeInformation<?> ti = TypeInfoParser.parse(sb);
            if (sb.length() > 0) {
                throw new IllegalArgumentException("String could not be parsed completely.");
            }
            return ti;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String could not be parsed: " + e.getMessage(), e);
        }
    }

    private static TypeInformation<?> parse(StringBuilder sb) throws ClassNotFoundException {
        Class<?> clazz;
        String className;
        String infoString = sb.toString();
        Matcher tupleMatcher = tuplePattern.matcher(infoString);
        Matcher writableMatcher = writablePattern.matcher(infoString);
        Matcher enumMatcher = enumPattern.matcher(infoString);
        Matcher basicTypeMatcher = basicTypePattern.matcher(infoString);
        Matcher basicTypeDateMatcher = basicTypeDatePattern.matcher(infoString);
        Matcher primitiveTypeMatcher = primitiveTypePattern.matcher(infoString);
        Matcher valueTypeMatcher = valueTypePattern.matcher(infoString);
        Matcher pojoGenericMatcher = pojoGenericObjectPattern.matcher(infoString);
        if (infoString.length() == 0) {
            return null;
        }
        Object returnType = null;
        boolean isPrimitiveType = false;
        if (tupleMatcher.find()) {
            className = tupleMatcher.group(1);
            sb.delete(0, className.length() + 1);
            int arity = Integer.parseInt(className.replaceAll("\\D", ""));
            clazz = className.startsWith(TUPLE_PACKAGE) ? TypeInfoParser.loadClass(className) : TypeInfoParser.loadClass("org.apache.flink.api.java.tuple." + className);
            TypeInformation[] types = new TypeInformation[arity];
            for (int i = 0; i < arity; ++i) {
                types[i] = TypeInfoParser.parse(sb);
                if (types[i] != null) continue;
                throw new IllegalArgumentException("Tuple arity does not match given parameters.");
            }
            if (sb.charAt(0) != '>') {
                throw new IllegalArgumentException("Tuple arity does not match given parameters.");
            }
            sb.deleteCharAt(0);
            returnType = new TupleTypeInfo(clazz, types);
        } else if (writableMatcher.find()) {
            className = writableMatcher.group(1);
            String fullyQualifiedName = writableMatcher.group(3);
            sb.delete(0, className.length() + 1 + fullyQualifiedName.length() + 1);
            clazz = TypeInfoParser.loadClass(fullyQualifiedName);
            returnType = WritableTypeInfo.getWritableTypeInfo(clazz);
        } else if (enumMatcher.find()) {
            className = enumMatcher.group(1);
            String fullyQualifiedName = enumMatcher.group(3);
            sb.delete(0, className.length() + 1 + fullyQualifiedName.length() + 1);
            clazz = TypeInfoParser.loadClass(fullyQualifiedName);
            returnType = new EnumTypeInfo(clazz);
        } else if (basicTypeMatcher.find()) {
            className = basicTypeMatcher.group(1);
            sb.delete(0, className.length());
            Class<?> clazz2 = className.startsWith("java.lang") ? TypeInfoParser.loadClass(className) : TypeInfoParser.loadClass("java.lang." + className);
            returnType = BasicTypeInfo.getInfoFor(clazz2);
        } else if (basicTypeDateMatcher.find()) {
            className = basicTypeDateMatcher.group(1);
            sb.delete(0, className.length());
            Class<?> clazz3 = className.startsWith("java.util") ? TypeInfoParser.loadClass(className) : TypeInfoParser.loadClass("java.util." + className);
            returnType = BasicTypeInfo.getInfoFor(clazz3);
        } else if (primitiveTypeMatcher.find()) {
            String keyword = primitiveTypeMatcher.group(1);
            sb.delete(0, keyword.length());
            Class<Object> clazz4 = null;
            if (keyword.equals("int")) {
                clazz4 = Integer.TYPE;
            } else if (keyword.equals("byte")) {
                clazz4 = Byte.TYPE;
            } else if (keyword.equals("short")) {
                clazz4 = Short.TYPE;
            } else if (keyword.equals("char")) {
                clazz4 = Character.TYPE;
            } else if (keyword.equals("double")) {
                clazz4 = Double.TYPE;
            } else if (keyword.equals("float")) {
                clazz4 = Float.TYPE;
            } else if (keyword.equals("long")) {
                clazz4 = Long.TYPE;
            } else if (keyword.equals("boolean")) {
                clazz4 = Boolean.TYPE;
            } else if (keyword.equals("void")) {
                clazz4 = Void.TYPE;
            }
            returnType = BasicTypeInfo.getInfoFor(clazz4);
            isPrimitiveType = true;
        } else if (valueTypeMatcher.find()) {
            className = valueTypeMatcher.group(1);
            sb.delete(0, className.length() + 5);
            Class<?> clazz5 = className.startsWith(VALUE_PACKAGE) ? TypeInfoParser.loadClass(className + "Value") : TypeInfoParser.loadClass("org.apache.flink.types." + className + "Value");
            returnType = ValueTypeInfo.getValueTypeInfo(clazz5);
        } else if (pojoGenericMatcher.find()) {
            boolean isPojo;
            String fullyQualifiedName = pojoGenericMatcher.group(1);
            sb.delete(0, fullyQualifiedName.length());
            boolean bl = isPojo = pojoGenericMatcher.group(2) != null;
            if (isPojo) {
                sb.deleteCharAt(0);
                clazz = TypeInfoParser.loadClass(fullyQualifiedName);
                ArrayList<PojoField> fields = new ArrayList<PojoField>();
                while (sb.charAt(0) != '>') {
                    Matcher fieldMatcher = fieldPattern.matcher(sb);
                    if (!fieldMatcher.find()) {
                        throw new IllegalArgumentException("Field name missing.");
                    }
                    String fieldName = fieldMatcher.group(1);
                    sb.delete(0, fieldName.length() + 1);
                    Field field = TypeExtractor.getDeclaredField(clazz, fieldName);
                    if (field == null) {
                        throw new IllegalArgumentException("Field '" + fieldName + "'could not be accessed.");
                    }
                    fields.add(new PojoField(field, TypeInfoParser.parse(sb)));
                }
                sb.deleteCharAt(0);
                returnType = new PojoTypeInfo(clazz, fields);
            } else {
                returnType = new GenericTypeInfo(TypeInfoParser.loadClass(fullyQualifiedName));
            }
        }
        if (returnType == null) {
            throw new IllegalArgumentException("Error at '" + infoString + "'");
        }
        int arrayDimensionCount = 0;
        while (sb.length() > 1 && sb.charAt(0) == '[' && sb.charAt(1) == ']') {
            ++arrayDimensionCount;
            sb.delete(0, 2);
        }
        if (sb.length() > 0 && sb.charAt(0) == '[') {
            throw new IllegalArgumentException("Closing square bracket missing.");
        }
        if (arrayDimensionCount > 0) {
            Object arrayInfo = null;
            if (isPrimitiveType) {
                if (returnType == BasicTypeInfo.INT_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.BYTE_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.SHORT_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.CHAR_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.DOUBLE_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.FLOAT_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.LONG_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.BOOLEAN_TYPE_INFO) {
                    arrayInfo = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.VOID_TYPE_INFO) {
                    throw new IllegalArgumentException("Can not create an array of void.");
                }
            } else if (returnType instanceof BasicTypeInfo && returnType != BasicTypeInfo.DATE_TYPE_INFO) {
                if (returnType == BasicTypeInfo.INT_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.BYTE_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.BYTE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.SHORT_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.SHORT_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.CHAR_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.CHAR_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.DOUBLE_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.DOUBLE_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.FLOAT_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.FLOAT_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.LONG_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.BOOLEAN_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.BOOLEAN_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.STRING_TYPE_INFO) {
                    arrayInfo = BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO;
                } else if (returnType == BasicTypeInfo.VOID_TYPE_INFO) {
                    throw new IllegalArgumentException("Can not create an array of void.");
                }
            } else {
                arrayInfo = ObjectArrayTypeInfo.getInfoFor(TypeInfoParser.loadClass("[L" + returnType.getTypeClass().getName() + ";"), returnType);
            }
            if (arrayDimensionCount > 1) {
                String arrayPrefix = "[";
                for (int i = 1; i < arrayDimensionCount; ++i) {
                    arrayPrefix = arrayPrefix + "[";
                    arrayInfo = ObjectArrayTypeInfo.getInfoFor(TypeInfoParser.loadClass(arrayPrefix + "L" + returnType.getTypeClass().getName() + ";"), arrayInfo);
                }
            }
            returnType = arrayInfo;
        }
        if (sb.length() > 0 && sb.charAt(0) == ',') {
            sb.deleteCharAt(0);
        }
        return returnType;
    }

    private static Class<?> loadClass(String fullyQualifiedName) {
        try {
            return Class.forName(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class '" + fullyQualifiedName + "' could not be found. Please note that inner classes must be declared static.");
        }
    }
}

